pro view_redrawdata
  @common
  @view_common

  if not fits_loaded then return

  wset, 2
  device, copy = [0, 0, 600, 600, 0, 0, 1]

  if view_lines then begin
    if view_lines_fewer then step = 30 else step = 15
    r = 8
    if view_circles and view_circles_fewer then r = 7
    sty = 0
    if view_lines_dotted then sty = 2
    c = '010000'xul * view_lines_b + $
	'000100'xul * view_lines_g + $
	'000001'xul * view_lines_r
    for i = 0, 359, step do begin
      x = cos(i / 180.0d * 3.1415926d)
      y = sin(i / 180.0d * 3.1415926d)

      plots, [x * 300.0d / 8.0d, x * 300.0d / 8.0d * r] + 299, $
	     [y * 300.0d / 8.0d, y * 300.0d / 8.0d * r] + 299, color = c, $
	     /device, linestyle = sty
    end
  endif
  
  if view_circles then begin  
    if view_circles_fewer then step = 2 else step = 1
    c = '010000'xul * view_circles_b + $
	'000100'xul * view_circles_g + $
	'000001'xul * view_circles_r
    sty = 0
    if view_circles_dotted then sty = 2
    for i = 1, 8, step do begin
      drawcircle, 299, 299, i / 8.0d * 300.0d, c, sty
    endfor
  endif

  if view_labels then begin
    label_charheight = view_labels_size
    label_circlesize = 0.65
    smult = label_charheight / 9.0D * 1.3

    a = view_labels_offs / 180.0d * 3.14159d

    maxr = 8
    if view_circles and view_circles_fewer then maxr = 7
    rstep = 1
    if view_circles and view_circles_fewer then rstep = 2
    if view_labels_fewer then rstep = 2 * rstep
    
    for r = 1, maxr, rstep do begin
      rpix = 300.0d / 8.0d * r
      x = rpix * cos(a) + 299
      y = rpix * sin(a) + 299
      drawcircle2, x, y, label_charheight * label_circlesize, $
	           smoothness = 64, color = view_labels_c_bg, filled = 1
      xyouts, x + 1, $
              y - label_charheight * 0.75 / 2, $
              zeroPad(r, 0), color = view_labels_c_text, alignment = 0.52, $
	      /device, charsize = 0.8 * smult
      xyouts, x, $
              y - label_charheight * 0.75 / 2, $
              zeroPad(r, 0), color = view_labels_c_text, alignment = 0.52, $
	      /device, charsize = 0.8 * smult
      drawcircle2, x, y, label_charheight * label_circlesize, $
	           smoothness = 64, color = view_labels_c_outer, filled = 0
      
    endfor     
  endif

  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 2]
end
