pro view_events, ev
  @common
  @view_common
  
  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'lines' then begin
    view_lines = widget_info(w_button_lines, /button_set)
    
    widget_control, w_button_dotted0, sensitive = view_lines
    widget_control, w_button_fewer0, sensitive = view_lines
    widget_control, w_slider_r0, sensitive = view_lines
    widget_control, w_slider_g0, sensitive = view_lines
    widget_control, w_slider_b0, sensitive = view_lines
  endif

  if uval eq 'circles' then begin
    view_circles = widget_info(w_button_circles, /button_set)
    
    widget_control, w_button_dotted1, sensitive = view_circles
    widget_control, w_button_fewer1, sensitive = view_circles
    widget_control, w_button_samecolor, sensitive = view_circles

    enable_colors = view_circles and not view_circles_samecolor
    widget_control, w_slider_r1, sensitive = enable_colors 
    widget_control, w_slider_g1, sensitive = enable_colors  
    widget_control, w_slider_b1, sensitive = enable_colors  
  endif

  if uval eq 'labels' then begin
    view_labels = widget_info(w_button_labels, /button_set)
    
    widget_control, w_slider_r2, sensitive = view_labels
    widget_control, w_slider_g2, sensitive = view_labels 
    widget_control, w_slider_b2, sensitive = view_labels 
    widget_control, w_slider_r3, sensitive = view_labels
    widget_control, w_slider_g3, sensitive = view_labels 
    widget_control, w_slider_b3, sensitive = view_labels 
    widget_control, w_slider_r4, sensitive = view_labels
    widget_control, w_slider_g4, sensitive = view_labels 
    widget_control, w_slider_b4, sensitive = view_labels 
    widget_control, w_slider_label_size, sensitive = view_labels  
    widget_control, w_label_label_size, sensitive = view_labels  
    widget_control, w_slider_label_offs, sensitive = view_labels  
    widget_control, w_label_label_offs, sensitive = view_labels 
    widget_control, w_button_fewer2, sensitive = view_labels     
  endif

  if uval eq 'samecolor' then begin
    view_circles_samecolor = widget_info(w_button_samecolor, /button_set)
    
    enable_colors = view_circles and not view_circles_samecolor
    widget_control, w_slider_r1, sensitive = enable_colors 
    widget_control, w_slider_g1, sensitive = enable_colors  
    widget_control, w_slider_b1, sensitive = enable_colors   
  endif

  if uval eq 'color0' then begin
    widget_control, w_slider_r0, get_value = view_lines_r
    widget_control, w_slider_g0, get_value = view_lines_g
    widget_control, w_slider_b0, get_value = view_lines_b

    wset, h_color0
    c = '010000'xul * view_lines_b + $
        '000100'xul * view_lines_g + $
        '000001'xul * view_lines_r

    polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = c
  endif 

  if uval eq 'circles' or uval eq 'samecolor' or uval eq 'color1' or $
     (uval eq 'color0' and view_circles_samecolor) then begin
    if not view_circles_samecolor then begin
      widget_control, w_slider_r1, get_value = view_circles_r
      widget_control, w_slider_g1, get_value = view_circles_g
      widget_control, w_slider_b1, get_value = view_circles_b
    endif else begin
      widget_control, w_slider_r0, get_value = view_circles_r
      widget_control, w_slider_g0, get_value = view_circles_g
      widget_control, w_slider_b0, get_value = view_circles_b
    endelse

    wset, h_color1
    c = '010000'xul * view_circles_b + $
        '000100'xul * view_circles_g + $
        '000001'xul * view_circles_r

    polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = c
  endif

  if uval eq 'color2' then begin
    r = 0
    g = 0
    b = 0
    widget_control, w_slider_r2, get_value = r
    widget_control, w_slider_g2, get_value = g
    widget_control, w_slider_b2, get_value = b

    wset, h_color2
    view_labels_c_outer = '010000'xul * b + '000100'xul * g + '000001'xul * r

    polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_outer
  endif 

  if uval eq 'color3' then begin
    r = 0
    g = 0
    b = 0
    widget_control, w_slider_r3, get_value = r
    widget_control, w_slider_g3, get_value = g
    widget_control, w_slider_b3, get_value = b

    wset, h_color3
    view_labels_c_bg = '010000'xul * b + '000100'xul * g + '000001'xul * r

    polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_bg
  endif 

  if uval eq 'color4' then begin
    r = 0
    g = 0
    b = 0
    widget_control, w_slider_r4, get_value = r
    widget_control, w_slider_g4, get_value = g
    widget_control, w_slider_b4, get_value = b

    wset, h_color4
    view_labels_c_text = '010000'xul * b + '000100'xul * g + '000001'xul * r

    polyfill, [-2, 2, 2, -2], [-2, -2, 2, 2], /normal, color = view_labels_c_text
  endif 

  if uval eq 'dotted0' then begin
    view_lines_dotted = widget_info(w_button_dotted0, /button_set)
  endif
    
  if uval eq 'dotted1' then begin
    view_circles_dotted = widget_info(w_button_dotted1, /button_set)
  endif
    
  if uval eq 'fewer0' then begin
    view_lines_fewer = widget_info(w_button_fewer0, /button_set)
  endif
    
  if uval eq 'fewer1' then begin
    view_circles_fewer = widget_info(w_button_fewer1, /button_set)
  endif

  if uval eq 'fewer2' then begin
    view_labels_fewer = widget_info(w_button_fewer2, /button_set)
  endif

  if uval eq 'label_size' then begin
    widget_control, w_slider_label_size, get_value = view_labels_size
    s = "Label size = " + zeropad(view_labels_size, 0)
    widget_control, w_label_label_size, set_value = s
  endif

  if uval eq 'label_offs' then begin
    widget_control, w_slider_label_offs, get_value = view_labels_offs
    view_labels_offs = view_labels_offs / 2.0d
    s = "Label offset = " + zeropad(fix(view_labels_offs), 0)
    widget_control, w_label_label_offs, set_value = s
  endif

  if uval eq 'loaddef' then begin
    view_setup_defaults
  endif

  if uval eq 'savedef' then begin
    save, view_lines, $
	  view_lines_dotted, $
	  view_lines_fewer, $
	  view_lines_r, $
	  view_lines_g, $
	  view_lines_b, $
	  view_circles, $
	  view_circles_dotted, $
	  view_circles_fewer, $
	  view_circles_samecolor, $
	  view_circles_r, $
	  view_circles_g, $
	  view_circles_b, $
	  view_labels, $
	  view_labels_fewer, $
	  view_labels_c_outer, $
	  view_labels_c_bg, $
	  view_labels_c_text, $
	  view_labels_size, $
	  view_labels_offs, $
	  filename = 'view_settings.sav'
  endif

;  if strmid(uval, 0, 5) eq 'color' or uval eq 'label_size' $
;     or uval eq 'label_offs' then begin
;    if ev.drag eq 1 then return
;  endif

  view_redrawdata
end
