pro setup_gui
  @common
  @cc_common
  @flattener_common

  device, retain = 2

  w_base = widget_base(xsize = 870, ysize = 742, title = 'xfTool', $
                       mbar = w_menubar)

  w_draw = widget_draw(w_base, xoffset = 4, yoffset = 4, $
                       xsize = 600, ysize = 600, /button_events, /motion_events)

  w_graph = widget_draw(w_base, xoffset = 4, yoffset = 608, $
                       xsize = 600, ysize = 128, /button_events, /motion_events)

  w_tab = widget_tab(w_base, xoffset = 608, yoffset = 22, scr_xsize = 258, $
                     scr_ysize = 312)		     

  ; ----
  ; set up tabs
  ; ----

  tabnames = ['view', 'flattener', 'azisum', 'radial']

  view_setup_tab, w_tab
  flattener_setup_tab, w_tab  	   
  azisum_setup_tab, w_tab
  radial_setup_tab, w_tab

  w_label_stats = widget_label(w_base, xoffset = 608, yoffset = 4, $
                                    /align_left, xsize = 200, ysize = 14, $
				    value = '(0, 0) : 0')

  w_button_loggraph = widget_button(w_base, xoffset = 608, yoffset = 686, $
                                    xsize = 258, ysize = 24, uvalue = 'log', $
				    value = 'Linear Y scale', sensitive = 0)

  w_label_yrange = widget_label(w_base, xoffset = 608, yoffset = 658, $
                                xsize = 56, ysize = 20, value = 'Y range:', $
				/align_left)

  w_text_yr0 = widget_text(w_base, xoffset = 664, yoffset = 652, $
                           scr_xsize = 48, scr_ysize = 30, value = '-1', $
			   uvalue = 'yrange0', /editable, sensitive = 0)

  w_label_through = widget_label(w_base, xoffset = 712, yoffset = 658, $
                                 xsize = 16, ysize = 20, value = 'to', $
		                 /align_center)
  
  w_text_yr1 = widget_text(w_base, xoffset = 730, yoffset = 652, $
                           scr_xsize = 48, scr_ysize = 30, value = '3', $
			   uvalue = 'yrange1', /editable, sensitive = 0)

  w_button_autoy = widget_button(w_base, xoffset = 782, yoffset = 655, $
                                 xsize = 84, ysize = 24, uvalue = 'autoy', $
		                 value = 'Manual', sensitive = 0)

  w_button_save = widget_button(w_base, xoffset = 608, yoffset = 712, $
                                xsize = 258, ysize = 24, uvalue = 'savedata', $
		                value = 'Save data...', sensitive = 0)

  cc_setup_gui, w_base, 608, 338, 266
  
  ; --- menu ---
  w_menu_file = widget_button(w_menubar, value = 'File', /menu)
  w_menu_file_load = widget_button(w_menu_file, value = 'Load FITS data...', $
                                   event_pro = 'event_load')
  w_menu_file_loadpng = widget_button(w_menu_file, value = 'Load PNG image...',$
                                   event_pro = 'event_loadpng')
  w_menu_file_savepng = widget_button(w_menu_file, value = 'Write PNG...', $
                                   event_pro = 'event_savepng', /separator)
  w_menu_file_loadsim = widget_button(w_menu_file, value = 'Load SIM data...',$
                                   event_pro = 'event_loadsim', /separator)
  w_menu_file_quit = widget_button(w_menu_file, value = 'Quit', $
                                   event_pro = 'event_quit', /separator)
  
  widget_control, w_base, /realize  
  widget_control, w_draw, get_value = h_draw
  widget_control, w_graph, get_value = h_graph
  widget_control, w_cc_draw, get_value = h_cc_draw

  wset, h_graph
  polyfill, [2, 2, -1, -1], [2, -1, -1, 2], /normal, color = 'ffffff'xul

  window, 1, /pixmap, xsize = 600, ysize = 600
  window, 2, /pixmap, xsize = 600, ysize = 600
  window, 3, /pixmap, xsize = 600, ysize = 600
  window, 4, /pixmap, xsize = 600, ysize = 128

  cc_loadct, 0
end
