pro radial_savegraph, filename
  @common
  @radial_common

  get_lun, fh
  openw, fh, filename
  printf, fh, '; xfRadial output file'
  printf, fh, '; fits: ', fits_filename_short
  printf, fh, '; divisions: ', strcompress(string(radial_divisions), /remove_all)
  printf, fh, '; offset: ', strcompress(string(radial_offset), /remove_all)
  printf, fh, '; overlap: ', strcompress(string(radial_overlap), /remove_all)
  printf, fh, '; L-divisions: ', strcompress(string(radial_l_divisions), /remove_all)

  if radial_all then $
    printf, fh, '; multiple slices: yes' $
  else $
    printf, fh, '; multiple slices: no'
  
  printf, fh, ';'
  
  if radial_all then begin
    hdr0 = '; L        '
    hdr1 = '; ---------'

    n = n_elements(radial_zaxis)
    for i = 0, n - 1 do begin
      hdr0 = hdr0 + ' ' + string(format = '(F9.2)', radial_zaxis[i])
      hdr1 = hdr1 + ' ---------'
    endfor

    printf, fh, hdr0
    printf, fh, hdr1
  endif else begin
    printf, fh, '; L         value'
    printf, fh, '; --------- ---------'
  endelse

  n = n_elements(radial_xaxis)
  m = n_elements(radial_zaxis)
  for i = 0, n - 1 do begin
    line = '  ' + string(format = '(F9.2)', radial_xaxis[i])
    for j = 0, m - 1 do begin
      line = line + ' ' + string(format = '(F9.2)', radial_data[j, i])
    endfor
    printf, fh, line
  endfor
  
  close, fh
  free_lun, fh

  print, 'wrote ', filename
end
