pro radial_redrawgraph, all
  @common
  @radial_common
  
  astep = 3.141592653 * 2 / double(radial_divisions)

  num_divs = 1
  if all then num_divs = radial_divisions

  offset = radial_offset

  radial_data = fltarr(num_divs, radial_l_divisions)
  radial_zaxis = fltarr(num_divs)

  wset, h_draw

  for j = 0, num_divs - 1 do begin
    radial_zaxis[j] = offset / 3.1415926d * 180.0d

    arr = fix(floor((radius_array / 8.0d) * radial_l_divisions) + 1)
    offs = offset - (astep / 2.0d) * (1 + radial_overlap / 100.0d / 2.0d)
    width = astep * (1 + radial_overlap / 100.0d)
    arr[where((angle_array - offs + 4 * 3.141592653) mod (3.141592653 * 2.0d) gt width)] = 0
    
    arr[radius_more_than_8] = 0

    if all then tvscl, arr

    w = where(arr gt 0)
    fdo = fits_data_original[w]
    arr = arr[w]  

    for i = 1, radial_l_divisions do begin
      w = where(arr eq i)
      
      if w eq [-1] then $
	radial_data[j, i - 1] = 0 $
      else $
	radial_data[j, i - 1] = mean(fdo[w])

    endfor

    offset = offset + astep
  endfor

  yrng = [0, max(radial_data) * 1.05]
  if loggraph then yrng = yrng > 0.01

  wset, 4
  plot, [0, 1], [0, 1], xrange = [0, 8], xstyle = 1, color = '000000'xul, $
        yrange = yrng, xtickinterval = 1, ylog = loggraph, $
	xminor = 4, background = 'ffffff'xul, /nodata
  
  oplot, [1, 1], [-1000, 1000], color = 'cccccc'xul
       
  plot, [0, 1], [0, 1], xrange = [0, 8], xstyle = 1, color = '000000'xul, $
        yrange = yrng, /nodata, /noerase, ylog = loggraph, $
	xtickinterval = 1, xminor = 4

  radial_xaxis = (indgen(radial_l_divisions) + 0.5) / radial_l_divisions * 8.0d
  
  for j = 0, num_divs - 1 do begin
    oplot, radial_xaxis, radial_data[j, *], color = '000000'xul
  endfor

  wset, h_graph
  device, copy = [0, 0, 600, 128, 0, 0, 4]
    
  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 2]

  radial_all = all

  radial_dataready = 1
  widget_control, w_button_save, sensitive = 1  
end
