pro radial_redrawdata
  @common
  @radial_common

  if not fits_loaded then return

  wset, 2
  device, copy = [0, 0, 600, 600, 0, 0, 1]

  drawcircle, 299, 299, 299, 'ffaa33'xul

  earth_rad = 300.0 / 8.0d
  
  drawcircle, 299, 299, earth_rad, 'ffaa33'xul

  a = radial_offset
  astep = 3.141592653 * 2 / double(radial_divisions)
  for i = 0, radial_divisions - 1 do begin
    x = cos(a)
    y = sin(a)
    plots, [x * 290, x * 299] + 299, [y * 290, y * 299] + 299, /device, $
           color = 'ffaa33'xul
    
    plots, [x * earth_rad, x * (earth_rad + 5)] + 299, $
           [y * earth_rad, y * (earth_rad + 5)] + 299, /device, $
   	   color = 'ffaa33'xul

    a = a + astep
  endfor

  a = radial_offset - (astep / 2.0d) * (1 + radial_overlap / 100.0d)
  x = cos(a)
  y = sin(a)
  plots, [x * earth_rad, x * 299] + 299, [y * earth_rad, y * 299] + 299, $
         /device, color = 'ffaa33'xul

  a = radial_offset + (astep / 2.0d) * (1 + radial_overlap / 100.0d)
  x = cos(a)
  y = sin(a)
  plots, [x * earth_rad, x * 299] + 299, [y * earth_rad, y * 299] + 299, $
         /device, color = 'ffaa33'xul

  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 2]
end
