pro radial_events, ev
  @radial_common
  
  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'divisions' then begin
    v = 0
    widget_control, w_slider_divisions, get_value = v
    radial_divisions = fix(v)

    s = strcompress(string(floor(radial_divisions)), /remove_all)

    widget_control, w_label_divisions, set_value = "Divisions = " + s 

    radial_redrawdata
    
    if ev.drag eq 0 then radial_redrawgraph, 0
  endif

  if uval eq 'offset' then begin
    v = 0
    widget_control, w_slider_offset, get_value = v
    radial_offset = v / 4.0d

    s = strcompress(string(floor(radial_offset)) + "." + string(floor((radial_offset * 10.0d) mod 10.0d)) + string(floor((radial_offset * 100.0d) mod 10.0d)), /remove_all)
    
    widget_control, w_label_offset, set_value = "Offset = " + s
    
    radial_offset = radial_offset / 180.0d * 3.141592653
    radial_redrawdata

    if ev.drag eq 0 then radial_redrawgraph, 0
  endif

  if uval eq 'overlap' then begin
    v = 0
    widget_control, w_slider_overlap, get_value = v
    radial_overlap = fix(v)

    if radial_overlap ge -3 and radial_overlap le 3 then radial_overlap = 0

    s = strcompress(string(floor(radial_overlap)), /remove_all)

    widget_control, w_label_overlap, set_value = "Overlap = " + s + "%"
    
    radial_redrawdata
    
    if ev.drag eq 0 then radial_redrawgraph, 0
  endif

  if uval eq 'l_divisions' then begin
    v = 0
    widget_control, w_slider_l_divisions, get_value = v
    radial_l_divisions = fix(v)

    s = strcompress(string(floor(radial_l_divisions)), /remove_all)

    widget_control, w_label_l_divisions, set_value = "L-Divisions = " + s 
    
    if ev.drag eq 0 then radial_redrawgraph, 0
  endif

;  if uval eq 'single' then radial_redrawgraph, 0
  
  if uval eq 'all' then radial_redrawgraph, 1
end
