; at^2 + bt + c = 0, solve for t.. returns -1 if no solution, else a pair
; (may be duplicates)
function quadratic, a, b, c
  t = -1
  det = b ^ 2 - 4 * a * c

  if det ge 0 then begin
    t = [(-b - sqrt(det)) / (2 * a), (-b + sqrt(det)) / (2 * a)]
  endif 

  return, t
end

pro flattener_redrawgraph
  @common
  @flattener_common

  if flattener_line_x0 eq -1 then begin
    wset, h_graph
    polyfill, [2, 2, -1, -1], [2, -1, -1, 2], /normal, color = 'ffffff'xul  
    return
  endif

  len = double(ceil(sqrt((flattener_line_x0 - flattener_line_x1) ^ 2 + (flattener_line_y0 - flattener_line_y1) ^ 2)))
  
  dir = [flattener_line_x1 - flattener_line_x0, flattener_line_y1 - flattener_line_y0]
  dir = dir / sqrt(dir[0] ^ 2 + dir[1] ^ 2)
  
  perp = [-(flattener_line_y1 - flattener_line_y0), flattener_line_x1 - flattener_line_x0]
  perp = perp / sqrt(perp[0] ^ 2 + perp[1] ^ 2)

  x = flattener_line_x0 + double(indgen(flattener_thickness) - ((flattener_thickness - 1) / 2)) * perp[0]
  y = flattener_line_y0 + double(indgen(flattener_thickness) - ((flattener_thickness - 1) / 2)) * perp[1]
  
  xstep = double(flattener_line_x1 - flattener_line_x0) / len
  ystep = double(flattener_line_y1 - flattener_line_y0) / len
  
  d = fltarr(len)
;  d_orig = fltarr(len)

  xx = flattener_line_x0 - 300
  yy = flattener_line_y0 - 300
  r = 2 / 8.0 * 300.0d
  
  for rr = 0.0d, 8.0d, 0.5d do begin
    r = rr / 8.0 * 300.0d
    t = quadratic((dir[0] ^ 2 + dir[1] ^ 2), 2 * (xx * dir[0] + yy * dir[1]), $
                  -r ^ 2 + xx ^ 2 + yy ^ 2)

    if t eq [-1] then t = [-200, -200]

    if rr eq 0 then begin
      tval = t 
      tname = ['0', '0']
    endif else begin
      tval = [tval, t]  

      if rr mod 1.0d eq 0.0d then $
      	rs = strcompress(string(fix(rr)), /remove_all) $      
      else $
        rs = ' '
      
      tname = [tname, rs, rs]
    endelse
  endfor

  s = sort(tval)
  tval = tval[s]
  tname = tname[s]

  s = where(tval ge 0 and tval le len - 1)
  tval = tval[s]
  tname = tname[s]

  for i = 0, len - 1 do begin
    d[i] = mean(fits_data[floor(x), floor(y)])    
;    d_orig[i] = mean(fits_data_original[floor(x), floor(y)])
    
    x = x + xstep
    y = y + ystep  
  endfor

  if autoy then begin
    y0 = min(d)
    y1 = max(d)
    yspan = y1 - y0
    yrng = [y0 - yspan * 0.05, y1 + yspan * 0.05]
  endif else begin
    yrng = [yrange0, yrange1]
  endelse

  if loggraph then yrng = yrng > 0.01

  wset, 4
  plot, d, background = 'ffffff'xul, color = '000000'xul, $
        xmargin = [5.2, 2], /nodata, $
        ymargin = [2.6, 1], yrange = yrng, xrange = [0, len - 1], $
       	xstyle = 1, xticks = n_elements(tval) - 1, xtickv = tval, $
	xtickname = tname, ylog = loggraph, ystyle = 1

  oplot, [t[0], t[0]], [-10, 10], color = 'cccccc'xul
  oplot, [t[1], t[1]], [-10, 10], color = 'cccccc'xul
  oplot, [0, len], [0, 0], color = 'bbbbbb'xul
  oplot, [0, len], [1, 1], color = '999999'xul
  oplot, [0, len], [2, 2], color = 'bbbbbb'xul
;  oplot, [l0, l0], [-10, 10], color = 'bbbbbb'xul
;  oplot, [l1, l1], [-10, 10], color = 'bbbbbb'xul
  
;  oplot, d_orig, color = 'aaaaaa'xul
  oplot, d, color = '000000'xul

  wset, h_graph
  device, copy = [0, 0, 600, 128, 0, 0, 4]

  widget_control, w_button_save, sensitive=1
end
