pro flattener_redrawdata
  @common
  @cc_common
  @flattener_common

  if not fits_loaded then return

  if data_altered then redrawdata

  wset, 3
  device, copy = [0, 0, 600, 600, 0, 0, 1]

  ; --- draw the partial circle ---
  r = flattener_circle_radius * 300.0d / 8.0d
  
  circle = fltarr(2, 32)

  swa = (3.14159d / 2.0d - atan(flattener_circle_radius, 1.0)) * 1.1

  angledist = 3.14159d * 2 - swa * 2

  s_a_o = (flattener_start_angle / 180.0d * 3.14159d) < angledist

  angledist = angledist - s_a_o
  
  e_a_o = (flattener_end_angle / 180.0d * 3.14159d) < angledist

  angledist = angledist - e_a_o
  
  a = fits_shadowAngle / 180.0d * 3.14159d + swa + s_a_o
  astep = angledist / 31
  
  for i = 0, 31 do begin
    circle[0, i] = 299 + r * cos(a)
    circle[1, i] = 299 + r * sin(a)
    
    a = a + astep
  endfor
  plots, circle, /device, color = 'ff7744'xul, psym = 0

  flattener_redrawbox
    
  ; --- plot back buffer to screen ---
  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 2]

  flattener_redrawgraph
end
