pro flattener_recalculate
  @common
  @flattener_common

  if not fits_loaded then return

  wset, h_draw
  xyouts, 4, 1, 'Recalculating...', color = '000000'xul, charsize = 1.33, /device
  xyouts, 3, 2, 'Recalculating...', color = 'ff9977'xul, charsize = 1.33, /device
  xyouts, 2, 2, 'Recalculating...', color = 'ff9977'xul, charsize = 1.33, /device
  xyouts, 2, 2, 'Recalculating...', color = 'ff9977'xul, charsize = 1.33, /device

  if flattener_recalc_avg then begin
    r = flattener_circle_radius * 300.0d / 8.0d
    
    circle = fltarr(2, 32)

    swa = (3.14159d / 2.0d - atan(flattener_circle_radius, 1.0)) * 1.1

    angledist = 3.14159d * 2 - swa * 2

    s_a_o = (flattener_start_angle / 180.0d * 3.14159d) < angledist

    angledist = angledist - s_a_o
    
    e_a_o = (flattener_end_angle / 180.0d * 3.14159d) < angledist

    angledist = angledist - e_a_o
    
    a_start = fits_shadowAngle / 180.0d * 3.14159d + swa + s_a_o
    a_end = a_start + angledist
    a_step = 1 / r

    a = a_start
    
    sum = 0
    count = 0
    
    while(a lt a_end) do begin
      count = count + 1
      sum = sum + fits_data_original[299 + r * cos(a), 299 + r * sin(a)]
      a = a + a_step
    endwhile

    flattener_arc_avg = sum / count
    flattener_recalc_avg = 0
  endif

  if flattener_func eq 0 then $
    flattener_curve_coeff = flattener_arc_avg / flattener_circle_radius ^ (-flattener_curve_exp) $
  else $
    flattener_curve_coeff = flattener_arc_avg / 10 ^ (-flattener_curve_exp * flattener_circle_radius)

  if flattener_func eq 0 then $
    fits_data = fits_data_original / (flattener_curve_coeff * radius_array ^ (-flattener_curve_exp)) $
  else $
    fits_data = fits_data_original / (flattener_curve_coeff * 10 ^ (-flattener_curve_exp * radius_array))
  
;  fits_data[where(radius_array lt 1.0)] = 0
  fits_data = fits_data - min(fits_data)
  fits_data_log = alog10((fits_data + 1.0) > 1.0)
  fits_data_byte = fix(fits_data_log / max(fits_data_log) * 255.0d)
  
  data_altered = 1
  fits_loaded = 1
  flattener_recalc_avg = 1

  flattener_redrawdata

  widget_control, w_button_saveas, sensitive = 1
end
