pro flattener_events, ev
  @common
  @flattener_common
  
  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'func' then begin
    flattener_func = (flattener_func + 1) mod 2
    
    widget_control, w_button_func, set_value = flattener_func_desc[flattener_func]

    if flattener_func eq 0 then begin
      flattener_curve_exp = 4.00
      widget_control, w_slider_slope, set_slider_max = 800
      widget_control, w_slider_slope, set_value = 400
      widget_control, w_label_slope, set_value = "x = 4.00"
    endif else begin
      flattener_curve_exp = 0.80
      widget_control, w_slider_slope, set_value = 80
      widget_control, w_slider_slope, set_slider_max = 100
      widget_control, w_label_slope, set_value = "x = 0.80"
    endelse
    
    
    flattener_recalc_avg = 1    
    flattener_recalculate
    flattener_redrawdata
    return
  endif

  if uval eq 'radius' then begin
    v = 0
    widget_control, w_slider_radius, get_value = v
    flattener_circle_radius = v / 100.0d

    s = strcompress(string(floor(flattener_circle_radius)) + "." + string(floor((flattener_circle_radius * 10.0d) mod 10.0d)) + string(floor((flattener_circle_radius * 100.0d) mod 10.0d)), /remove_all)

    widget_control, w_label_radius, set_value = "L = " + s 
   
    if ev.drag eq 0 then begin
      flattener_recalc_avg = 1
      flattener_recalculate
      flattener_is_dragging = 0
      return
    endif else begin
      if not flattener_is_dragging then begin
        fits_data_byte = fits_data_byte_original
        data_altered = 1
	flattener_is_dragging = 1
      endif
    endelse
    
    flattener_redrawdata

    return
  endif
  
  if uval eq 'slope' then begin
    v = 0
    widget_control, w_slider_slope, get_value = v
    flattener_curve_exp = v / 100.0d

    s = strcompress(string(floor(flattener_curve_exp)) + "." + string(floor((flattener_curve_exp * 10.0d) mod 10.0d)) + string(floor((flattener_curve_exp * 100.0d) mod 10.0d)), /remove_all)

    widget_control, w_label_slope, set_value = "x = " + s 

    if ev.drag eq 0 then begin
      flattener_recalculate 
    endif

    return
  endif
  
  if uval eq 'start_angle' then begin
    v = 0
    widget_control, w_slider_startangle, get_value = v
    flattener_start_angle = v / 100.0d

    s = strcompress(string(floor(flattener_start_angle)) + "." + string(floor((flattener_start_angle * 10.0d) mod 10.0d)) + string(floor((flattener_start_angle * 100.0d) mod 10.0d)), /remove_all)

    widget_control, w_label_startangle, set_value = "Start angle offset = " + s 

    if ev.drag eq 0 then begin
      flattener_recalculate 
    endif
    
    flattener_redrawdata
    return
  endif
  
  if uval eq 'end_angle' then begin
    v = 0
    widget_control, w_slider_endangle, get_value = v
    flattener_end_angle = v / 100.0d

    s = strcompress(string(floor(flattener_end_angle)) + "." + string(floor((flattener_end_angle * 10.0d) mod 10.0d)) + string(floor((flattener_end_angle * 100.0d) mod 10.0d)), /remove_all)

    widget_control, w_label_endangle, set_value = "End angle offset = " + s 

    if ev.drag eq 0 then begin
      flattener_recalculate 
    endif

    flattener_redrawdata
    return
  endif
  
  if uval eq 'flattener_thickness' then begin
    v = 0
    widget_control, w_slider_thick, get_value = v
    flattener_thickness = v * 2 + 1

    s = strcompress(string(floor(flattener_thickness)), /remove_all) + " pixel"
    if v gt 1 then s = s + "s"

    widget_control, w_label_thick, set_value = "Thickness = " + s

    flattener_redrawbox
    
    if ev.drag eq 0 or 1 then begin
      flattener_redrawgraph
    endif

    return
  endif

  if uval eq 'saveas' then begin
    filename = dialog_pickfile(filter = '*.fits', /write)    
    if filename eq '' then return
    
    writefits, filename, fits_data, fits_header    
    return
  endif
end
