pro flattener_event_draw, ev
  @common
  @flattener_common

  if not fits_loaded then return

  x = 0 > ev.x < 599
  y = 0 > ev.y < 599

  if ev.press eq 1 then begin
    flattener_line_x0 = -1
    flattener_line_y0 = -1
    flattener_line_x1 = -1
    flattener_line_y1 = -1

    flattener_redrawdata
    
    flattener_line_x0 = ev.x
    flattener_line_y0 = ev.y
    flattener_line_x1 = ev.x
    flattener_line_y1 = ev.y
    flattener_is_dragging_line = 1
    wset, 3
    device, copy = [0, 0, 600, 600, 0, 0, h_draw]
  endif  

  if ev.release eq 1 then begin
    flattener_line_x1 = x
    flattener_line_y1 = y
    flattener_is_dragging_line = 0

    flattener_redrawgraph
    return
  endif

  if flattener_is_dragging_line then begin
    flattener_line_x1 = x
    flattener_line_y1 = y

    flattener_redrawbox
  endif

  if flattener_line_x0 ne -1 then begin
    wset, h_graph
    device, copy = [0, 0, 600, 128, 0, 0, 4]
    
    x0 = flattener_line_x0
    y0 = flattener_line_y0
    x1 = flattener_line_x1
    y1 = flattener_line_y1
    d = ((y0 - y1) * x + (x1 - x0) * y + (x0 * y1 - x1 * y0)) / $
        sqrt((x1 - x0) ^ 2 + (y1 - y0) ^ 2)
      
    if d gt flattener_thickness then return

    dir = [-(y1 - y0), x1 - x0]
    dir = dir / sqrt(dir[0] ^ 2 + dir[1] ^ 2)
    p = [x, y]
    pp = [x0, y0]

    p0 = p + dir * d
    p1 = p - dir * d

    d0 = sqrt((p0[0] - pp[0]) ^ 2 + (p0[1] - pp[1]) ^ 2)
    d1 = sqrt((p1[0] - pp[0]) ^ 2 + (p1[1] - pp[1]) ^ 2)

    dst = d0 < d1   
    
    oplot, [1, 1] * dst, [-1000, 1000], color = 'ff0000'xul
  endif
end
