pro event_savepng, ev
  @common

  path = '.'
  filename = 'out.png'
  
  if fits_loaded then begin
    i = strpos(fits_filename_chopped, '/', /reverse_search)
    if i ne -1 then begin
      path = strmid(fits_filename_chopped, 0, i)
      filename = strmid(fits_filename_chopped, i + 1) + '.png'
    endif else begin
      path = '.'
      filename = fits_filename_chopped + '.png'
    endelse
  endif    

  print, path
  print, filename
  print, fits_filename_chopped

  filename = dialog_pickfile(filter = '*.png', /write, path = path, $
                             file = filename)

  if filename eq '' then return
  
  wset, h_draw
  img = tvrd(true = 1)

  write_png, filename, img
end
