pro event_savegraph, ev
  @common

  default = 'out.txt'
  if fits_loaded then begin
    if curtab eq 'azisum' then default = azisum_savegraph_defname()
    if curtab eq 'radial' then default = radial_savegraph_defname()
  endif

  i = strpos(default, '/', /reverse_search)
  if i ne -1 then begin
    path = strmid(default, 0, i)
    filename = strmid(default, i + 1)
  endif else begin
    path = '.'
    filename = default
  endelse

  filename = dialog_pickfile(filter = '*.txt', /write, path = path, $
                             file = filename)

  if filename eq '' then return
			   
  if curtab eq 'azisum' then azisum_savegraph, filename
  if curtab eq 'radial' then radial_savegraph, filename
end
