 
; $Id: event_loadsim.pro,v 1.5 2006/03/29 18:06:15 terryf Exp $

pro event_loadsim, ev
  @common
  @cc_common
  @flattener_common
  @tabs_common

  line = ''
  keyw = ''
  val = ''
  fformat = "UN"

  filename = dialog_pickfile(filter = '*.sim', /must_exist, /read)

  if(filename eq '') then begin
      print, 'No file chosen.'
      return
  endif


; -------------------------------------------------------
; read through the file and determine the number of lines
; in the file, and also the number of header lines (lines
; containing a ":" character
; -------------------------------------------------------
  openr, luin, filename, /get_lun
  num_lines = 0
  num_headers = 0
  while (not eof(luin)) do begin
      readf, luin, line
      num_lines = num_lines + 1
      line = strcompress(line,/remove_all)
      cln = strpos(line,":")
      if (cln ne -1) then num_headers = num_headers + 1
  endwhile
  
;;  print, "Number of lines is   ", num_lines
;;  print, "Number of headers is ", num_headers
  close, luin
  
  num_data = num_lines - num_headers
; ----------------------------------------
; open the file again and read the header,
; then the data
; ----------------------------------------
  openr, luin, filename, /get_lun
  
  for i=0,num_headers-1 do begin
      readf, luin, line
      line = strcompress(line,/remove_all)
      cln = strpos(line,":")

      llen = strlen(line)

      keyw =  strmid(line,0,cln)
      val  =  strmid(line,cln+1)

      case keyw of

          'TIME': begin
              time =  val

          end

          'FORMAT': begin
              fformat =  val

          end

          'XSTART': begin
              reads, val, xstart

          end

          'YSTART': begin
              reads, val,ystart

          end

          'XEND': begin
              reads, val, xend

          end

          'YEND': begin
              reads, val, yend

          end

          'XLENGTH': begin
              reads, val, xlength

          end

          'YLENGTH': begin
              reads, val, ylength

          end

          else:

      endcase

  endfor

  if (fformat eq "UN") then fformat = "PT"

  if((fformat ne "XY") and (fformat ne "PT")) then begin
      print, "Unknown format code: ",fformat, ", exiting"
      return
  endif

; ----------------------------------------------
; read in the data, depending on the format code
; ----------------------------------------------
  arrlen = fix(xlength) * fix(ylength)
  barr = fltarr(3,arrlen)

  for i = 0,num_data-1 do begin
      readf, luin, xx, yy, dd, ff
      barr[0,i] = xx
      barr[1,i] = yy
      barr[2,i] = dd

  endfor


  close, luin
  free_lun, luin

; ----------------------------------------------------
; reform the data into a rectangular cartesian grid if
; necessary
; ----------------------------------------------------
  if(fformat eq "PT") then begin
      xxx = barr[1,*] * cos(barr[0,*])
      yyy = barr[1,*] * sin(barr[0,*])
  endif else begin
      xxx = barr[0,*]
      yyy = barr[1,*]
  endelse

; -----------------------------------------------------------
; interpolate to get a 600x600 array for the output FITS file
; -----------------------------------------------------------
;;;;;;;  del = (xend - xstart) / 600.0
  del = 16.0 / 600.0
  xout = findgen(600)
;;;;;;;  xout = (xout*del) + xstart + (del/2.0)
  xout = (xout*del) -8.0 + (del/2.0)
  yout = xout

  triangulate,xxx,yyy,ttt

  rr = trigrid(xxx,yyy,barr[2,*],ttt,xout=xout,yout=yout,missing=0.0)

; --------------------------------------------
; clear out the center circle (set to zero)
; --------------------------------------------
  for i=0,599 do begin
      for j=0,599 do begin
          if(sqrt(xout[i]*xout[i] + yout[j]*yout[j]) le 1.0) then rr[i,j] =0.0
      endfor
  endfor


; -------------------
; load the data
; -------------------
  fits_data = rotate(rr,2)

  fits_data_log = alog10((fits_data + 1.0) > 1.0)
  fits_data_byte = fix(fits_data_log / max(fits_data_log) * 255.0d)

  fits_data_original = fits_data
  fits_data_byte_original = fits_data_byte

  if(fformat eq "PT") then fits_anglemode = 0 else fits_anglemode = 1
  fits_maxL = xend
  fits_shadowAngle = 180.0 ;?????


  data_altered = 1
  fits_loaded = 1
  flattener_recalc_avg = 1

  fits_filename = filename

  i = strpos(filename, '/', /reverse_search)
  if i gt -1 then $
    fits_filename_short = strmid(filename, i + 1) $
  else $
    fits_filename_short = filename

  i = strpos(filename, '.', /reverse_search)
  if i gt -1 then $
    fits_filename_chopped = strmid(filename, 0, i) $
  else $
    fits_filename_chopped = filename


  fits_stamp1 = fits_filename_chopped
  fits_stamp2 = fits_filename_chopped

  png_loaded = 0

  recalculate

  widget_control, w_cc_list, sensitive = 1
  widget_control, w_cc_label_gamma, sensitive = 1
  widget_control, w_cc_slider_gamma, sensitive = 1
  widget_control, w_base, base_set_title = 'xfTool - [' + fits_filename_short + ']'

end

