pro event_loadpng, ev
  @common
  @cc_common
  @tabs_common

  filename = dialog_pickfile(filter = '*.png', /must_exist, /read)

  if(filename eq '') then begin
    print, 'No file chosen.'
    return
  endif
  
  img = read_png(filename)

  wset, 1
  tv, img, true = 1
  
  fits_loaded = 1

  fits_filename = filename
  
  i = strpos(filename, '/', /reverse_search)
  if i gt -1 then $
    fits_filename_short = strmid(filename, i + 1) $
  else $
    fits_filename_short = filename
  
  i = strpos(filename, '.', /reverse_search)
  if i gt -1 then $
    fits_filename_chopped = strmid(filename, 0, i) $
  else $
    fits_filename_chopped = filename

  widget_control, w_tab, set_tab_current = 0
  curtab = 'view'

  wset, h_graph
  polyfill, [2, 2, -1, -1], [2, -1, -1, 2], /normal, color = 'ffffff'xul  

  png_loaded = 1

  view_redrawdata

  widget_control, w_cc_list, sensitive = 0
  widget_control, w_cc_label_gamma, sensitive = 0
  widget_control, w_cc_slider_gamma, sensitive = 0
end

