pro event_load, ev
  @common
  @flattener_common
  @cc_common

  filename = dialog_pickfile(filter = '*.fits', /must_exist, /read)

  if(filename eq '') then begin
    print, 'No file chosen.'
    return
  endif
  
  ; -------------
  ; read the data
  ; -------------
  fits_data = readfits(filename, fits_header)
;  fits_data = alog10((fits_data + 1.0) > 1.0)

  ; -------------------------------------------------
  ; get the angle mode, max L and timestamps from
  ; the FITS header
  ; -------------------------------------------------
  fits_anglemode   = sxpar(fits_header, 'ANG_MODE')
  fits_maxL        = sxpar(fits_header, 'MAX_L')
  fits_stamp1      = sxpar(fits_header, 'STARTMID')
  fits_stamp2      = sxpar(fits_header, 'STOPMID')
  fits_shadowAngle = sxpar(fits_header, 'SHADOWAN')

  if fits_stamp1 eq 0 then begin
      fits_stamp1 = '<>'
      fits_stamp2 = '<>'
  end

  fits_data_log = alog10((fits_data + 1.0) > 1.0)
  fits_data_byte = fix(fits_data_log / max(fits_data_log) * 255.0d)
  
  fits_data_original = fits_data
  fits_data_byte_original = fits_data_byte
  
  data_altered = 1
  fits_loaded = 1
  flattener_recalc_avg = 1

  fits_filename = filename
  
  i = strpos(filename, '/', /reverse_search)
  if i gt -1 then $
    fits_filename_short = strmid(filename, i + 1) $
  else $
    fits_filename_short = filename
  
  i = strpos(filename, '.', /reverse_search)
  if i gt -1 then $
    fits_filename_chopped = strmid(filename, 0, i) $
  else $
    fits_filename_chopped = filename

  png_loaded = 0
  
  recalculate

  widget_control, w_cc_list, sensitive = 1
  widget_control, w_cc_label_gamma, sensitive = 1
  widget_control, w_cc_slider_gamma, sensitive = 1
  widget_control, w_base, base_set_title = 'xfTool - [' + fits_filename_short + ']'
end

