pro event_draw, ev
  @common
  
  x = 0 > ev.x < 599
  y = 0 > ev.y < 599

  r = sqrt((x - 300.0) ^ 2 + (y - 300.0) ^ 2) / 300.0d * 8.0d
  a = atan(y - 300.0, x - 300.0) / 3.14159d * 180.0d
  while a lt 0 do a = a + 360.0d
  v = fits_data[x, y]
  
;  sx = strcompress(string(floor(x)), /remove_all)
;  sy = strcompress(string(floor(y)), /remove_all)

  sr = strcompress(string(floor(r)) + "." + string(floor((r * 10.0d) mod 10.0d)) + string(floor((r * 100.0d) mod 10.0d)), /remove_all)
  
  sa = strcompress(string(floor(a)) + "." + string(floor((a * 10.0d) mod 10.0d)) + string(floor((a * 100.0d) mod 10.0d)), /remove_all)

  sv = tostr(v)
  
  widget_control, w_label_stats, set_value = '(' + sr + ', ' + sa + ') : ' + sv

  if curtab eq 'flattener' then flattener_event_draw, ev
  if curtab eq 'view' then view_event_draw, ev
end
