pro cc_events, ev
  @common
  @cc_common
  @flattener_common
  
  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'list' then begin
    cc_loadct, widget_info(w_cc_list, /list_select)    
  endif else if uval eq 'gamma' then begin
    v = 0
    widget_control, ev.id, get_value = v
    cc_gamma = v / 100.0d

    if (cc_gamma gt 0.95d) and (cc_gamma lt 1.05d) then cc_gamma = 1.00

    s = strcompress(string(floor(cc_gamma)) + "." + string(floor((cc_gamma * 10.0d) mod 10.0d)) + string(floor((cc_gamma * 100.0d) mod 10.0d)), /remove_all)

    widget_control, w_cc_label_gamma, set_value = "Gamma: " + s

    cc_gamma_lookup = byte(((indgen(255) / 255.0d) ^ (1.0d / cc_gamma)) * 255.0d)

    n = indgen(256)
    cc_red_altered = cc_red[cc_gamma_lookup[n]]
    cc_green_altered = cc_green[cc_gamma_lookup[n]]
    cc_blue_altered = cc_blue[cc_gamma_lookup[n]]

    if ev.drag eq 0 then begin
      data_altered = 1
      redrawdata
    endif 

    cc_redrawpreview
  endif
end
