pro azisum_savegraph, filename
  @common
  @azisum_common

  get_lun, fh
  openw, fh, filename
  printf, fh, '; xfAzisum output file'
  printf, fh, '; fits: ', fits_filename_short
  printf, fh, '; date: ', systime()
  printf, fh, '; inner radius: ', strcompress(string(azisum_radius0), /remove_all)
  printf, fh, '; thickness: ', strcompress(string(azisum_radius1), /remove_all)
  printf, fh, '; divisions: ', strcompress(string(azisum_divisions), /remove_all)
  
  if azisum_mlon then $
    printf, fh, '; x-axis: magnetic longitude' $
  else $
    printf, fh, '; x-axis: magnetic local time'

  printf, fh, ';'
  
  if azisum_mlon then $
    printf, fh, '; MLON      value' $
  else $
    printf, fh, '; MLT       value'
  
  printf, fh, '; --------- ---------'

  n = n_elements(azisum_xaxis)
  for i = 0, n - 1 do begin
    printf, fh, format = '("  ", F9.2, " ", F9.2)', $
                azisum_xaxis[i], azisum_data[i]
  endfor
  
  close, fh
  free_lun, fh

  print, 'wrote ', filename
end
