pro azisum_redrawgraph
  @common
  @azisum_common
  
  aa = angle_array
  
  if not azisum_mlon then begin
    shadowangle = fits_shadowAngle / 180.0 * 3.1415926  
    aa = aa - shadowangle
    aa[where(aa lt 0)] = aa[where(aa lt 0)] + 3.1415926 * 2
  endif
  
  arr = fix(floor(aa/ 3.1415926 / 2.0d * azisum_divisions) + 1)
  arr[where(radius_array lt azisum_radius0)] = 0
  arr[where(radius_array gt (azisum_radius0 + azisum_radius1))] = 0

;  wset, h_draw
;  tvscl, arr
  
  w = where(arr gt 0)
  fdo = fits_data_original[w]
  arr = arr[w]    

  azisum_data = fltarr(azisum_divisions)
  
  for i = 1, azisum_divisions do begin
    w = where(arr eq i)
    if w eq [-1] then $
      azisum_data[i - 1] = 0 $
    else $
      azisum_data[i - 1] = mean(fdo[w])
  endfor

  azisum_xaxis = indgen(azisum_divisions) / double(azisum_divisions[0]) * 360.0d
  azisum_xaxis = azisum_xaxis + 360.0d / azisum_divisions / 2.0d
 
  azisum_xaxis2 = [azisum_xaxis - 360.0, azisum_xaxis, azisum_xaxis + 360.0]
 
  xrng = [-90, 450]
  xti = 90

  if not azisum_mlon then begin
    azisum_xaxis = azisum_xaxis / 360.0 * 24.0
    azisum_xaxis2 = azisum_xaxis2 / 360.0 * 24.0
    xrng = [-6, 30]
    xti = 6
  endif
  
  azisum_data2 = [azisum_data, azisum_data, azisum_data]

  wset, 4
  plot, azisum_xaxis, azisum_data, xrange = xrng, xstyle = 1, color = '000000'xul, $
        yrange = [0, max(azisum_data) * 1.05], xtickinterval = xti, $
	xminor = 6, background = 'ffffff'xul, /nodata

  oplot, azisum_xaxis2, azisum_data2, color = 'bbbbbb'xul
  oplot, azisum_xaxis, azisum_data, color = '000000'xul

  wset, h_graph
  device, copy = [0, 0, 600, 128, 0, 0, 4]

  azisum_dataready = 1
  widget_control, w_button_save, sensitive = 1
end
