pro azisum_redrawdata
  @common
  @azisum_common

  if not fits_loaded then return

  wset, 2
  device, copy = [0, 0, 600, 600, 0, 0, 1]

  drawcircle, 299, 299, azisum_radius0 * 300.0 / 8.0d, 'ffaa33'xul
  drawcircle, 299, 299, (azisum_radius0 + azisum_radius1) * 300.0 / 8.0d, $
              'ffaa33'xul

  a = 0
  if not azisum_mlon then a = fits_shadowAngle / 180.0d * 3.1415926
  astep = 3.141592653 * 2.0 / double(azisum_divisions)

  l = 3 < azisum_radius1 * 300.0 / 8.0

  r0 = azisum_radius0 * 300.0 / 8.0 + l
  r1 = azisum_radius0 * 300.0 / 8.0 
  r2 = (azisum_radius0 + azisum_radius1) * 300.0 / 8.0 
  r3 = (azisum_radius0 + azisum_radius1) * 300.0 / 8.0 - l
  
  for i = 0, azisum_divisions - 1 do begin
    x = cos(a)
    y = sin(a)
    plots, [r0, r1] * x + 299, [r0, r1] * y + 299, $
           color = 'ffaa33'xul, /device
    plots, [r2, r3] * x + 299, [r2, r3] * y + 299, $
           color = 'ffaa33'xul, /device
    a = a + astep
  endfor    

  a = 0
  if not azisum_mlon then a = fits_shadowAngle / 180.0d * 3.1415926

  x = cos(a)
  y = sin(a)
  plots, [0, x * ((azisum_radius0 + azisum_radius1) * 300.0 / 8.0 + 32)]+299, $
         [0, y * ((azisum_radius0 + azisum_radius1) * 300.0 / 8.0 + 32)]+299, $
	 color = 'ffaa33'xul, /device	 
    
  wset, h_draw
  device, copy = [0, 0, 600, 600, 0, 0, 2]
end
