pro azisum_events, ev
  @azisum_common
  
  uval = ''
  widget_control, ev.id, get_uvalue = uval

  if uval eq 'divisions' then begin
    v = 0
    widget_control, w_slider_divisions, get_value = v
    azisum_divisions = fix(v)

    s = strcompress(string(floor(azisum_divisions)), /remove_all)

    widget_control, w_label_divisions, set_value = "Divisions = " + s 

    azisum_redrawdata

    if ev.drag eq 0 then azisum_redrawgraph
  endif

  if uval eq 'radius0' then begin
    v = 0
    widget_control, w_slider_radius0, get_value = v
    azisum_radius0 = v / 100.0d

    s = strcompress(string(floor(azisum_radius0)) + "." + string(floor((azisum_radius0 * 10.0d) mod 10.0d)) + string(floor((azisum_radius0 * 100.0d) mod 10.0d)), /remove_all)
    
    widget_control, w_label_radius0, set_value = "Inner radius = " + s
    
    azisum_redrawdata

    if ev.drag eq 0 then azisum_redrawgraph
  endif

  if uval eq 'radius1' then begin
    v = 0
    widget_control, w_slider_radius1, get_value = v
    azisum_radius1 = v / 100.0d

    s = strcompress(string(floor(azisum_radius1)) + "." + string(floor((azisum_radius1 * 10.0d) mod 10.0d)) + string(floor((azisum_radius1 * 100.0d) mod 10.0d)), /remove_all)
    
    widget_control, w_label_radius1, set_value = "Thickness = " + s
    
    azisum_redrawdata
    
    if ev.drag eq 0 then azisum_redrawgraph
  endif

  if uval eq 'mlontoggle' then begin
    azisum_mlon = not azisum_mlon
    
    if azisum_mlon then $
      widget_control, w_button_mlontoggle, set_value = "Magnetic Longitude" $
    else $
      widget_control, w_button_mlontoggle, set_value = "Magnetic Local Time"

    azisum_redrawdata
    azisum_redrawgraph
  endif
end
