pro reduce_satm, satm_file, yrday, start_hour, start_min, start_sec, $
                 end_hour, end_min, end_sec, whole_file=whole_file,  $
                 flux_option=flux_option, debug=debug, useExtMAGA=useExtMAGA
; callable procedure which will drive the satm reduction procedures.
; written by:  Norman T. Reese, Hughes STX, 1/20/92
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1

if n_params() eq 0 then begin
   satm_file = '  '
   read,'Satm filename (ex. L821040921C.satm)? ', satm_file
   print,'   '
   print,'FLUX TYPES:'
   print,'1 = raw counts'
   print,'2 = number flux'
   print,'3 = energy flux'
   print,'4 = distribution function'
   read,'Flux option (1,2,3,4)? ', flux_option 
endif
if ((n_params() le 1) and not keyword_set(whole_file)) then begin 
   read,'Starting yrday (ex. 81302)? ', yrday
   read,'Starting time? (hh mm ss) ', start_hour, start_min, start_sec
   read,'Ending yrday (ex. 81302)? ', end_yrday
   read,'Ending time? (hh mm ss) ', end_hour, end_min, end_sec
endif

if keyword_set(whole_file) then begin
   start_hour = 0 & start_min  = 0 & start_sec  = 0
   end_hour   = 0 & end_min    = 0 & end_sec    = 0
   yrday      = 0L & end_yrday = 0L
endif

 start_ms  = long( start_hour  * 3600000L +     $
                   start_min   *   60000L +     $
                   start_sec   *    1000L)
 end_ms    = long( end_hour    * 3600000L +     $
                   end_min     *   60000L +     $
                   end_sec     *    1000L)
 if (n_elements(end_yrday) gt 0) then $
	end_ms = end_ms + long(end_yrday - yrday) * 86400000L

 print, "Processing File:  ", satm_file, ", from ", start_ms, " to ", end_ms

 if not keyword_set(debug) then debug = 0
t=systime(1)
 process_satm,satm_file,yrday,start_ms,end_ms,hlapi,ea,gm,status,debug=debug,$
	useExtMAGA=useExtMAGA
print,'Time for process_satm, seconds', systime(1)-t

 name_type = ["rc","nf","ef","df"]

if (strmid(status,0,2) ne "**") then begin ; processed okay
   time_hms = ms2hhmmss(ea(0).time)
   save_file = string(hlapi.satid,format='(a1)') +   $ 
               string(hlapi.yrday,format='(i5.5)') + $
               string(time_hms(0),format='(i2.2)') + $
               string(time_hms(1),format='(i2.2)')
                     
;if flux is requested, calc flux and save flux information, else just save
;   raw counts.  (flux information will also contain raw counts in case
;   additional fluxes are desired)
  if keyword_set(flux_option) then begin
    if ( (flux_option gt 0) and (flux_option lt 5) ) then begin
      save_file=save_file+string(name_type(flux_option-1),format='(a2)')+'.xdr'
      if hlapi.satid eq "L" then begin ; LAPI
	calc_flux, hlapi, ea, flux_option, flux_type, energy, flux_elec, $
	  flux_ions, fluxOne_elec, fluxOne_ions, geiger_0, geiger_90, GM=GM
	save,file=save_file, HLAPI, EA, flux_option, flux_type, $
	  flux_elec, flux_ions, fluxOne_elec, fluxOne_ions,   $
	  geiger_0, geiger_90, GM, energy, /xdr
      endif else begin ; HAPI
	calc_flux, hlapi, ea, flux_option, flux_type, energy, flux_elec, $
	  flux_ions, fluxOne_elec, fluxOne_ions
	save,file=save_file, HLAPI, EA, flux_option, flux_type, $
	  flux_elec, flux_ions, fluxOne_elec, fluxOne_ions, energy, /xdr
      endelse
    endif else begin ; bad flux_option
      print,"UNKNOWN FLUX TYPE (Must be 1-4):",flux_option," Saving raw counts"
      save_file = save_file + '.xdr'
      if hlapi.satid eq "L" then save,file=save_file,hlapi,ea,gm,/xdr $
			    else save,file=save_file,hlapi,ea,/xdr
    endelse
  endif else begin ; no flux_option set
    save_file = save_file + '.xdr'
    if hlapi.satid eq "L" then save,file=save_file,hlapi,ea,gm,/xdr $
			  else save,file=save_file,hlapi,ea,/xdr
  endelse
  print, 'IDL saveset created in XDR format: ', save_file
endif else begin
;  print,"%%%Error finding time range:  ",strmid(file_info,17,16)
  print, "In SATM file:  ", satm_file, "; Read_SATM status:  ", status
endelse
return
end ; reduce_satm
