; 1996 July 12 Robert.M.Candey.1@gsfc.nasa.gov
; restore HAPI, LAPI files and write out as ASCII for 
;		swchang@physics.auburn.edu (Shen-Wu Chang)
files = findfile('*.xdr',count=nFiles)
for i=0L,nFiles-1 do begin
  restore, files(i)
  full_xdr_name = files(i)
  loc            = strpos( strupcase(full_xdr_name), ".XDR")
;  xdr_ver       = strmid( full_xdr_name, loc-1, 1)
  xdr_name      = strmid( full_xdr_name, loc-12, 12)
  print,"Full XDR FILE NAME:  ",full_xdr_name
  filename = xdr_name + '.asc'
  print,filename
  openw, lun, filename, /get_lun
  format = '(f6.2, f9.1, f6.2, f6.1, f6.2, f6.1, f8.1, f6.1, I9)'
  header = '  IL      Eng  elogf   ePA   ilogf  iPA    ALT   MLT   UT'
  printf,lun, hlapi.yrday, '  ', hlapi.satid, '  ',flux_type
  printf,lun, header
  if hlapi.satid eq 'L' then begin
    wPAe = (where(ea(100).sensors_elec eq 24, wc))(0)
    if wc ne 1 then wPAe = (where(ea(100).sensors_elec eq 8, wc))(0)
    if wc ne 1 then begin
	print, 'no PAe found', ea(100).sensors_elec
	goto, noPA
    endif
    wPAi = (where(ea(100).sensors_ions eq 25, wc))(0)
    if wc ne 1 then wPAi = (where(ea(100).sensors_ions eq 9, wc))(0)
    if wc ne 1 then begin
	print, 'no PAi found', ea(100).sensors_ions
	goto, noPA
    endif
  endif else begin
    wPAe = (where(ea(100).sensors_elec eq 0, wc))(0)
    if wc ne 1 then begin
	print, 'no PAe found', ea(100).sensors_elec
	goto, noPA
    endif
    wPAi = (where(ea(100).sensors_ions eq 1, wc))(0)
    if wc ne 1 then begin
	print, 'no PAi found', ea(100).sensors_ions
	goto, noPA
    endif
  endelse
  fluxe = flux_elec * 0.
  w = where(flux_elec gt 0, wc)
  if wc gt 0 then fluxe(w) = alog10(flux_elec(w))
  fluxi = flux_ions * 0.
  w = where(flux_ions gt 0, wc)
  if wc gt 0 then fluxi(w) = alog10(flux_ions(w))
  for j = 0L, n_elements(ea)-1 do begin
    ea1 = ea(j)
    for k = 0L, n_elements(energy)-1 do begin 
      printf,lun, ea1.ilat, energy(k), fluxe(wPAe,k,j), ea1.PA_elec(wPAe), $
	fluxi(wPAi,k,j), ea1.PA_ions(wPAi), ea1.alt, ea1.mlt, ea1.time, $
	format=format
    endfor ; k
  endfor ; j
noPA:
  free_lun, lun
endfor ; i
end
