pro sort_sens_hapi, counts, sensors, PA, EA, hlapi, debug=debug
; SORT_SENSORS.PRO sorts the sensor arrays into a specified order
;  by Bobby Candey (Atlantic Research) and Norman Reese (STx) 1990 October 31
;  modified by Jodi Humphreys to work with HAPI  1992 September 1
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1

; if not keyword_set (debug) then debug=0

sensorOrder = [2,7,1,6,3,8,0,5,4,9,10]
wBadSensors = where( sensors gt 9, wbadc )
if (wBadc gt 0) then sensors(wBadSensors) = 10 ; 30

for i = 0L, hlapi.nsweeps-1 do begin
  for j = 0L, n_elements(PA(0,*,0))-1 do begin ; hlapi.nsteps
    sensor_sort = sensors(*,i)
    PA_sort = PA(*,j,i)
    counts_sort = counts(*,j,i)
    sensorOrderIndex  = sort ( sensorOrder (sensor_sort) )
    sensor_sort = sensor_sort( sensorOrderIndex )
    PA_sort = PA_sort( sensorOrderIndex )
    counts_sort = counts_sort( sensorOrderIndex )
    wElec = where( ((sensor_sort mod 2) eq 0) and (sensor_sort lt 10), n_elec )
    wIons = where( ((sensor_sort mod 2) eq 1) and (sensor_sort lt 10), n_ions )

; *** error handling for sensors
    if (n_elec gt hlapi.nsensors_elec) then begin
      print,"Error in # of Electron Sensors:  ",sensor_sort(wElec)
      wElec = wElec(0:hlapi.nsensors_elec-1)
      n_elec = n_elements(wElec)
    endif
    if (n_ions gt hlapi.nsensors_ions) then begin
      print,"Error in # of Ion Sensors:  ",sensor_sort(wIons)
      wIons = wIons(0:hlapi.nsensors_Ions-1)
      n_ions = n_elements(wIons)
    endif
;   print,sensor_sort(wElec),sensor_sort(wIons)
    if (n_elec gt 0) then begin
      if j eq 0 then EA(i).sensors_elec = sensor_sort( wElec )
      EA(i).PA_elec(*,j) = PA_sort( wElec )
      EA(i).counts_elec(*,j) = counts( SensorOrderIndex(wElec), j, i)
    endif
    if (wIons(0) ge 0) then begin
      if j eq 0 then  EA(i).sensors_ions = sensor_sort( wIons )
      EA(i).PA_ions(*,j) = PA_sort( wIons )
      EA(i).counts_ions(*,j) = counts( SensorOrderIndex(wIons), j, i)
    endif

  endfor ; j
endfor ; i

return
end ; sort_sens_hapi
