;function conv_vax_unix,x
;return,x
;end
pro read_satm, satm_file, yrday_start, msec_start, msec_end, $
                 satm, satid, status

; version = '3.0'
version = '3.1'
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
; Norman T. Reese, ST Systems Corp., 30 Sep 91
; modified by Josephine N. Humphreys, Hughes STX, 28 Aug 92 to work for HAPI
; added reading on Unix machines, Bobby Candey, Code 632, 1994 Nov 23
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1
; realized VMS fix length files don't have reclen at beginning RMC; 1995 Jun 19
; added special skip for RECL=4564 for 256 zeros; RMC 1999 July 2
; added check for 512 block size and shift to Unix mode; RMC 2001 July 17
; 2020Mar6 RMC add brackets
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
; open satm file
 openr,lun,satm_file, /get_lun
 satm_file_info = fstat(lun)
 full_satm_name = satm_file_info.name
 loc            = strpos( strupcase(full_satm_name), ".SATM")
 satm_ver       = strmid( full_satm_name, loc-1, 1)
 satm_name      = strmid( full_satm_name, loc-11, 18)
 print,"Full SATM FILE NAME:  ",full_satm_name
; recl = !err
;  if ((strupcase(!version.arch) eq 'VAX') or $
;	(strupcase(!version.arch) eq 'ALPHA')) then onVAX = 1 else onVAX = 0
  if (strupcase(!version.os) eq 'VMS') then onVAX = 1 else onVAX = 0
;2001 July 17 (if 512 then copied from Unix system)
  if (strupcase(!version.os) eq 'VMS') then fromUnix = 0 else fromUnix = 1
  if (onVAX eq 1) then if satm_file_info.rec_len eq 512 then fromUnix = 1
;  if (onVAX eq 1) then begin
  if (fromUnix eq 0) then begin
    recl = satm_file_info.rec_len
  endif else begin
;    read_vax_block,lun,byte_array,end_of_file,error_flag,/extend
;    if error_flag then message,'Read_VAX_block error_flag = '+string(error_flag)
;    if (not error_flag) then recl = n_elements(byte_array)+2
;    free_lun,lun
    testSizes = [4820, 2516, 4308, 4564, 2260, 5704]
    w = where((satm_file_info.size mod testSizes) eq 0, wc)
    if (wc le 0) then begin
          print,'Unrecognized SATM File Format (record size)!'
          print,'In file: ', satm_file, '  Quitting Program'
          status= "** Unrecognized record size for lapi or hapi satm file"
          return
    endif
    if (wc gt 1) then begin
          print,'Unrecognized SATM File Format (multiple possible record sizes)'
          print,'In file: ', satm_file, '  Quitting Program'
          status= "** Unrecognized record size for lapi or hapi satm file"
          return
    endif
    recl = testSizes[w[0]]
;    openr,lun,satm_file, /get_lun
  endelse
; added 2001 July 17
  if (fromUnix eq 1) and (onVAX eq 1) then begin ; file moved from Unix to VMS
    free_lun, lun ; close file
    openr,lun,satm_file, /get_lun, recl, /block
      ; reopen with correct record length
;    satm_file_info = fstat(lun)
  endif

 case recl of
      4820: begin		
            satID="L"		; LAPI
            count_size=4096L	; 16 sensors x 32 steps/sec
            pps_size=512L
            skip_size=1L ; skip zeros at end of record
	    print,'**LAPI 16 sensors x 32 steps/sec, Record length: 4820'
            end
      2516: begin
            satID="L"		; LAPI
            count_size=2048L	; 16 sensors x 16 steps/sec
            pps_size=256L
            skip_size=1L ; skip zeros at end of record
	    print,'**LAPI 16 sensors x 16 steps/sec, Record length: 2516'
            end
      4308: begin
            satID="L"		; LAPI
            count_size=3840L	; 30 sensors x 16 steps/sec
            pps_size=256L
            skip_size=1L ; skip zeros at end of record
	    print,'**LAPI 30 sensors x 16 steps/sec, Record length: 4308'
            end
      4564: begin
            satID="L"		; LAPI
            count_size=3840L	; 30 sensors x 16 steps/sec
            pps_size=256L
            skip_size=257L ; skip zeros at end of record
	    print,'**LAPI 30 sensors x 16 steps/sec, Record length: 4564'
            end
      2260: begin
            satID="L"		; LAPI
            count_size=1920L	; 30 sensors x 8 steps/sec
            pps_size=128L
            skip_size=1L ; skip zeros at end of record
	    print,'**LAPI 30 sensors x 8 steps/sec, Record length: 2260'
            end
      5704: begin
            satID="H"		; HAPI
            count_size=4096L
            pps_size=512L
            skip_size=0L ; skip zeros at end of record
	    print,'**HAPI 8 sensors x 64 steps/sec, Record length: 5704'
            end
      else: begin
            print,'Unrecognized SATM File Format (record size)!'
            print,'In file: ', satm_file, '  Quitting Program'
            status= "** Unrecognized record size for lapi or hapi satm file"
            return
            end
endcase
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
; Set up the array size depending on the amount of time requested.
if ( yrday_start le 0 ) then begin ; read whole file
   if (satid eq "L") then max_recs = 1500L else max_recs = 3000L
   msec_start  = 0L
   msec_end    = 2 * 86400000L ; 2 days
endif else begin
   msec_start = msec_start - 7999L
   msec_end   = msec_end   + 7999L
   max_recs   = (msec_end - msec_start)/8000L + 6 ; 8000ms per major frame
  ; need at least 6 records for syncing
endelse
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
;Define the SATM_REC structure:
 if satID eq "L" then $ ; LAPI structure setup
  satm_r = $
  {SATM_REC, date:0l, time:0l, flag:0b, ilat:0.0, mlt:0.0, alt:0.0, lat:0.0, $
            lon:0.0, lst:0.0, lshell:0.0, orbit:0.0, gei_speed:0.0, sza:0.0, $
            dark_light:0b, num_sensors:0b, mag_data:fltarr(3,8),            $
            gm_data:bytarr(2,8),                                            $
            start_pps1:0b, stop_pps1:0b, skip_pps1:0b, step_pps1:0b,        $
            start_pps2:0b, stop_pps2:0b, skip_pps2:0b, step_pps2:0b,        $
            sea:intarr(4),sensor_id:bytarr(32),                             $
            counts:bytarr(count_size),pps:bytarr(pps_size) }                $
 else $ ; HAPI structure setup
  satm_r = $
  {SATM_REC2, date:0l, time:0l, flag:0b, ilat:0.0, mlt:0.0, alt:0.0, lat:0.0, $
            lon:0.0, lst:0.0, lshell:0.0, orbit:0.0, gei_speed:0.0, sza:0.0, $
            dark_light:0b, num_sensors:0b, mode:0b,          $ 
            mag_data:fltarr(2,128),  nadir:lonarr(2),                   $
            start_pps:0b, stop_pps:0b, skip_pps:0b, step_pps:0b,        $
            sensor_id:bytarr(8),                             $
            counts:bytarr(count_size),pps:bytarr(pps_size) }
;            counts:bytarr(4096),pps:bytarr(512) }
satm = replicate (satm_r, max_recs)
if skip_size gt 0 then skipArray = bytarr(skip_size) ; dummy to read zeros at end of record
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
;Advance file to record before requested start time
     check_time = msec_start - 8000L
;
;read entire first record in case requested time is at beginning of file 
;
  if (onVAX eq 1) then begin
    if (fromUnix eq 1) then begin
      if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
      if skip_size gt 0 then begin
        w0 = where(skipArray ne 0, w0c)
        if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
      endif
    endif else readu,lun,satm_r
  endif else begin
;    read_vax_block,lun,byte_array,end_of_file,error_flag,/extend
;    if error_flag then message, 'Read_SATM error: VAX conversion problem'
;    readStruc, byte_array, satm_r
    if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
;2020    satm_r = conv_vax_unix(satm_r)
    satm_r = conv_vax_unix(satm_r, /noswap)
    if skip_size gt 0 then begin
      w0 = where(skipArray ne 0, w0c)
      if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
    endif
  endelse
  read_time = satm_r.time + long(satm_r.date - yrday_start) * 86400000L
;
;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
  if ( yrday_start le 0 ) then begin ; read whole file
     read_time = msec_start
     yrday_start = satm_r.date
     goto,read_data
  endif
;
;search for 'just before' the first record requested.
;     
while ( read_time lt check_time ) do begin
  if ( eof(lun) ) then begin
    print,'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&'
    print,'File does not contain requested data range:  ',satm_file
    status = "** File does not contain requested data range"
    free_lun,lun
    return
  endif
  if (onVAX eq 1) then begin
    if (fromUnix eq 1) then begin
      if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
      if skip_size gt 0 then begin
        w0 = where(skipArray ne 0, w0c)
        if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
      endif
    endif else readu,lun,satm_r
  endif else begin
;    read_vax_block,lun,byte_array,end_of_file,error_flag,/extend
;    if error_flag then message, 'Read_SATM error: VAX conversion problem'
;    readStruc, byte_array, satm_r
    if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
;2020    satm_r = conv_vax_unix(satm_r)
    satm_r = conv_vax_unix(satm_r, /noswap)
    if skip_size gt 0 then begin
      w0 = where(skipArray ne 0, w0c)
      if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
    endif
  endelse
  read_time = satm_r.time + long(satm_r.date - yrday_start) * 86400000L
endwhile

;+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;
read_data:
  nframes = -1
while ((not eof(lun)) and ((read_time le msec_end) or (nframes lt 5))) do begin
; need 6 records for syncing
  nframes = nframes + 1
  if (nframes ge max_recs) then message,'Exceeded expected number of major frames'
  satm[nframes] = satm_r
  if (onVAX eq 1) then begin
    if (fromUnix eq 1) then begin
      if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
      if skip_size gt 0 then begin
        w0 = where(skipArray ne 0, w0c)
        if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
      endif
    endif else readu,lun,satm_r
  endif else begin
;    read_vax_block,lun,byte_array,end_of_file,error_flag,/extend
;    if error_flag then message, 'Read_SATM error: VAX conversion problem'
;    readStruc, byte_array, satm_r
    if skip_size gt 0 then readu,lun,satm_r, skipArray else readu,lun,satm_r
;2020    satm_r = conv_vax_unix(satm_r)
    satm_r = conv_vax_unix(satm_r, /noswap)
    if skip_size gt 0 then begin
      w0 = where(skipArray ne 0, w0c)
      if (w0c gt 0) then message, /info, 'Unexpected nonzeros at end of record'
    endif
  endelse
  read_time = satm_r.time + long(satm_r.date - yrday_start) * 86400000L
endwhile

if (eof(lun) and (nframes lt (max_recs-1))) then begin ; store last record
  nframes = nframes + 1
  satm(nframes) = satm_r
endif
free_lun,lun

; reduce structure to actual size of data
print,"Number of Frames:",nframes
if (nframes lt 0) then begin
  status = "** File does not contain requested data range"
endif else begin ; processed ok, return full satm filename as status
 satm = satm[0:nframes]
 status = full_satm_name
endelse
return
end ; read_satm
