function avg, x
return, total(x)/n_elements(x)
end

pro deload_ave, filename, start, finish, res, abx, aby, abz, amod_bx,$
                amod_by, amod_bz, mid_alt, mid_mlt, mid_ilat, mid_mlat,$
                mid_mlng, mid_time, flag
; Procedure to read in and average the data.
openr, unit, filename, /get_lun, /f77_unformatted
;
; Variable declaration
top = 86400
yr = 0L
dy = 0L
ms = 0L
md = 0L
mid_time = lonarr(top)
abx = fltarr(top)
aby = abx & abz = abx
amod_bx = fltarr(top)
amod_by = amod_bx & amod_bz = amod_bx
mid_alt = abx & mid_mlng = abx & mid_mlat = abx
mid_mlt = abx & mid_ilat = abx
temp_bx = fltarr(16) & temp_by = temp_bx & temp_bz = temp_bx
temp_mbx = temp_bx & temp_mby = temp_bx & temp_mbz = temp_bx
temp_ilat = fltarr(16) & temp_alt = temp_ilat & temp_mlt = temp_ilat
temp_mlng = temp_ilat & temp_mlat = temp_ilat
temp_time = fltarr(16)
flag = 1
;
; Perform binary search
;
status = fstat(unit)                      ;Retrieve file information
records = status.size / status.rec_len    ;Number of records
rec_len = status.rec_len                  ;Record size
middle = records / 2                      ;Middle of file
location = 0
new_location = middle
bin_inc = middle
point_lun, unit, new_location * rec_len   ;Move to center of file
while (abs(location - new_location) gt 1) do begin
    bin_inc = bin_inc / 2
    location = new_location
    readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz, glt,$
           mlg, mll, mt, il
    if ms gt start then new_location = new_location - bin_inc
    if ms le start then new_location = new_location + bin_inc
    point_lun, unit, new_location * rec_len
endwhile
;
; End binary search
;
if new_location lt location then new_location = new_location - 1
if new_location ge location then new_location = location - 1
;
; Move to one record before start time.
point_lun, unit, new_location * rec_len

; Read in data.
i = 0
n = 0L
if res eq '1' then inc = 1000
if res eq '1/2' then inc = 500
if res eq '1/4' then inc = 250
if res eq '1/8' then inc = 125
temp = start
readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz, glt,$
       mlg, mll, mt, il
while (ms lt start) do begin
       readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz, glt,$
       mlg, mll, mt, il
endwhile
while (ms ge start) and (ms lt finish) and (not eof (unit)) do begin
   if (ms ge temp) and (ms lt (temp+inc)) then begin
      temp_time(i) = ms
      temp_bx(i) = x
      temp_by(i) = y
      temp_bz(i) = z
      temp_mbx(i) = mx
      temp_mby(i) = my
      temp_mbz(i) = mz
      temp_mlt(i) = mt
      temp_ilat(i) = il
      temp_alt(i) = glt
      temp_mlng(i) = mlg
      temp_mlat(i) = mll
      i = i + 1
      readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz, glt,$
             mlg, mll, mt, il
   endif else begin
      if i gt 1 then begin
         mid_time(n) = temp + (inc/2)
         abx(n) = avg(temp_bx(0:i-1))
         aby(n) = avg(temp_by(0:i-1))
         abz(n) = avg(temp_bz(0:i-1))
         amod_bx(n) = avg(temp_mbx(0:i-1))
         amod_by(n) = avg(temp_mby(0:i-1))
         amod_bz(n) = avg(temp_mbz(0:i-1))
         mid_mlt(n) = $
               spline(temp_time(0:i-1), temp_mlt(0:i-1), mid_time(n))
         mid_alt(n) = $
               spline(temp_time(0:i-1), temp_alt(0:i-1), mid_time(n))
         mid_ilat(n) = $
               spline(temp_time(0:i-1), temp_ilat(0:i-1), mid_time(n))
         mid_mlat(n) = $
               spline(temp_time(0:i-1), temp_mlat(0:i-1), mid_time(n))
         mid_mlng(n) = $
               spline(temp_time(0:i-1), temp_mlng(0:i-1), mid_time(n))
         n = n + 1
         i = 0
      endif
      if i eq 1 then begin
         mid_time(n) = temp + (inc/2)
         abx(n) = temp_bx(0)
         aby(n) = temp_by(0)
         abz(n) = temp_bz(0)
         amod_bx(n) = temp_mbx(0)
         amod_by(n) = temp_mby(0)
         amod_bz(n) = temp_mbz(0)
         mid_mlt(n) = temp_mlt(0)
         mid_alt(n) = temp_alt(0)
         mid_ilat(n) = temp_ilat(0)
         mid_mlat(n) = temp_mlat(0)
         mid_mlng(n) = temp_mlng(0)
         n = n + 1
         i = 0
      endif
      temp = temp + inc
   endelse
endwhile
if n gt 0 then begin
   mid_time = mid_time(0:n-1)
   mid_mlt = mid_mlt(0:n-1)
   mid_alt = mid_alt(0:n-1)
   mid_ilat = mid_ilat(0:n-1)
   mid_mlat = mid_mlat(0:n-1)
   mid_mlng = mid_mlng(0:n-1)
   abx = abx(0:n-1)
   aby = aby(0:n-1)
   abz = abz(0:n-1)
   amod_bx = amod_bx(0:n-1)
   amod_by = amod_by(0:n-1)
   amod_bz = amod_bz(0:n-1)
endif else begin
   print, 'There is no data for this time period.'
   print, 'Choose another time period.'
   flag = 0
endelse
free_lun, unit
return
end
