pro dehires_load, filename, start, finish, bx, by, bz, mod_bx, mod_by,$
                  mod_bz, galt, mlt, ilat, mlong, mlat, time, flag
; Procedure to read in the data.
openr, unit, filename, /get_lun, /f77_unformatted
; Variable declaration
yr = 0L
dy = 0L
ms = 0L
md = 0L
top = 86400
time = lonarr(top)
bx = fltarr(top)
by = bx & bz = bx
mod_bx = fltarr(top)
mod_by = mod_bx & mod_bz = mod_bx
galt = bx & mlong = bx & mlat = bx
mlt = bx & ilat = bx
flag = 1
;
; Perform binary search
;
status = fstat(unit)                      ;Retrieve file information
records = status.size / status.rec_len    ;Number of records
rec_len = status.rec_len                  ;Record size
middle = records / 2                      ;Middle of file
location = 0
new_location = middle
bin_inc = middle
point_lun, unit, new_location * rec_len   ;Move to center of file
while (abs(location - new_location) gt 1) do begin
    bin_inc = bin_inc / 2
    location = new_location
    readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz, glt,$
           mlg, mll, mt, il
    if ms gt start then new_location = new_location - bin_inc
    if ms le start then new_location = new_location + bin_inc
    point_lun, unit, new_location * rec_len
endwhile
;
; End binary search
;
if new_location lt location then new_location = new_location - 1
if new_location ge location then new_location = location - 1
;
; Move to one record before start time.
point_lun, unit, new_location * rec_len

; Read in data.
n = 0L
while ((not eof (unit)) and (n lt top)) do begin
   readu, unit, yr, dy, ms, md, x, y, z, mx, my, mz,$
          glt, mlg, mll, mt, il
   if (ms ge start) and (ms lt finish) then begin
      time(n) = ms
      bx(n) = x
      by(n) = y
      bz(n) = z
      mod_bx(n) = mx
      mod_by(n) = my
      mod_bz(n) = mz
      galt(n) = glt
      mlong(n) = mlg
      mlat(n) = mll
      mlt(n) = mt
      ilat(n) = il
      n = n + 1
;      mm = n mod 100
;      if mm eq 0 then print, n,'th record read.'
  endif
  if ms gt finish then goto, nomore
  next_record:
endwhile
nomore:
if n gt 0 then begin
   time = time(0:n-1)
   bx = bx(0:n-1)
   by = by(0:n-1)
   bz = bz(0:n-1)
   mod_bx = mod_bx(0:n-1)
   mod_by = mod_by(0:n-1)
   mod_bz = mod_bz(0:n-1)
   galt = galt(0:n-1)
   mlong = mlong(0:n-1)
   mlat = mlat(0:n-1)
   mlt = mlt(0:n-1)
   ilat = ilat(0:n-1)
endif else begin
   print, 'There is no data for this time period.'
   print, 'Choose another time period.'
   flag = 0
endelse
free_lun, unit
return
end
