function CALC_PA_HAPI,Bphi,Btheta,sensors,nsteps
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1
; changed order of PA elements and changed bad_sensid code; 1995 Feb 2
; moved cos30, sin30 out of loop for efficiency; 1995 Feb 16, BC

pi = 4. * atan(1.0)
radeg = pi / 180.

nsweeps  = n_elements(sensors(0,*))
nsensors = n_elements(sensors(*,0)) 
;PA = fltarr ( nsensors, nsweeps, nsteps )
PA = fltarr ( nsensors, nsteps, nsweeps )
;    HAPI Pitch Angles
offset = [0., 0., 12., 12., -12., -12., 45., 45., -45., -45., 0.] * radeg

Bphi1 = Bphi * radeg
Btheta1 = Btheta * radeg

bad_sensid = where( (sensors lt 0) or (sensors gt 9), wc)
if (wc gt 0 ) then sensors(bad_sensid) = 10 ; 30

cos30 = cos(30.*radeg) & sin30 = sin(30.*radeg)
;    detector angles
for i = 0L, nsweeps-1 do for j = 0L, nsteps-1 do $
   PA(*,j,i) = cos(offset(sensors(*,i))) * sin(Btheta1(j,i)) * $
            (cos(Bphi1(j,i)) * cos30 +  $ 
             sin(Bphi1(j,i)) * sin30) - $
             sin(offset(sensors(*,i))) * cos(Btheta1(j,i))
;   PA(*,j,i) = cos(offset(sensors(*,i))) * sin(Btheta1(i*nsteps + j)) * $
;            (cos(Bphi1(i*nsteps + j)) * cos30 +  $ 
;             sin(Bphi1(i*nsteps + j)) * sin30) - $
;             sin(offset(sensors(*,i))) * cos(Btheta1(i*nsteps + j))

PA = -1.0 > PA < 1.0
PA = acos(PA)/ radeg

; flag UNKNOWN Pitch Angle of Unknown Sensors to 999.99
if (wc gt 0) then begin
  for j = 0L, nsteps-1 do begin
    PAtemp = PA(*,j,*)
    PAtemp(bad_sensid) = 999.99
    PA(*,j,*) = PAtemp
  endfor ; j
endif

return, PA
end ; calc_PA_HAPI
