pro readstruc, inByteArray, outStruc, offset
; read byteArray values into structure already defined in outStruc
; starting at offset into inByteArray
; 1994 Nov 23, Bobby Candey, NASA GSFC Code 632
; 1995 Jan 26, Robert.M.Candey@gsfc.nasa.gov

if (n_params() lt 2) then message, 'Error: ReadStruc, inByteArray, outStructure'
bSize = size(inByteArray)
oSize = size(outStruc)
if (oSize(0) eq 0) then message, 'Error: outStruc must be defined'
if (bSize(0) lt 1) then message, 'Error: inByteArray must be a defined array'
if (bSize(bSize(0)+1) ne 1) then $
	message, 'Error: inByteArray must be a byte array'
if (oSize(oSize(0)+1) ne 8) then message, 'Error: outStruc must be a structure'
;if (bSize(bSize(0)+2) ne n_tags(outStruc,/length)) then $
;  message, 'Error: Size of inByteArray and outStruc parameters must equal'
if (n_elements(offset) le 0) then offset = 0L

for i = 0L, n_tags(outStruc)-1 do begin
  xSize = size(outStruc.(i))
  nx = xSize(xSize(0)+2) ; number of elements
  case xSize(xSize(0)+1) of ; type code
    0: message, 'ReadStruc: undefined structure element'
    1: begin ; bytes
	y = byte(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx
	end
    2: begin ; short integers
	y = fix(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx*2
	end
    3: begin ; long integers
	y = long(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx*4
	end
    4: begin ; short floats
	y = float(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx*4
	end
    5: begin ; double floats
	y = double(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx*8
	end
    6: begin ; complex floats
	y = complex(inByteArray, offset, nx)
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	offset = offset + nx*8
	end
    7: begin ; strings
	y = outStruc.(i)
	for j = 0L, nx-1 do begin
	  ns = strlen(y(j))
	  y(j) = string(inByteArray(offset:offset+ns-1))
	  offset = offset + ns
	endfor ; j
	if (nx eq 1) then outStruc.(i) = y(0) else outStruc.(i) = y
	end
    8: begin ; substructure
	xStruc = outStruc.(i)
	readstruc, inByteArray(offset:*), xStruc, offset
	outStruc.(i) = xStruc
	end
    else: message, 'ReadStruc: unknown structure element'
    endcase
endfor ; i
return
end ; readStruc
