function CALC_PA_LAPI,Bx,By,Bz,encoder_angle,sensors,gmlat
; updated Robert.M.Candey@gsfc.nasa.gov; 1995 Feb 1

pi = 4. * atan(1.0)
radeg = pi / 180.

nsweeps  = n_elements(sensors(0,*))
nsensors = n_elements(sensors(*,0)) 

R = sqrt(Bx^2 + By^2)
Bmag = sqrt (Bx^2 + By^2 + Bz^2)
sin_phi = Bx / R
cos_phi = By / R
sin_theta = R / Bmag
cos_theta = Bz / Bmag

PA = fltarr ( nsensors, nsweeps )

;    LAPI Pitch Angles
offset = [0., 0., 180., 180., 30., 30., 172.5, 172.5, 7.5, 7.5, 45., 45.,$
          112.5, 112.5, 97.5, 97.5, 165., 165., 60., 60., 135., 135., $
          105., 105., 15., 15., 180., 180., 0., 0.]
offset = offset * radeg
;    detector angles (alpha or delta)
encoder_angle1 = encoder_angle - 90.
;    the encoder angle was defined with respect to the Y-axis and
;      the formulas are defined with respect to the X-axis

sgn = replicate( 1., nsweeps )
w = where(gmLat ge 0, wc)
if (wc gt 0) then sgn(w) = -1.

skewangle  = replicate( 90., nsensors, nsweeps )
; Set unknown SENSID's to 30
bad_sensid = where( (sensors lt 0) or (sensors gt 29), wbadc)
if (wbadc gt 0) then begin
;        print, 'Sensors out of bounds, engineering? ', sensors(bad_sensid)
  sensors( bad_sensid ) = 30      ; ### could be any value, maybe 99
endif ; out-of-bound sensors
field_aligned = where( ( sensors eq  0 ) or ( sensors eq  1 ) or $
                            ( sensors eq 26 ) or ( sensors eq 27 ), wc)
if (wc gt 0) then skewangle( field_aligned ) = 85.
field_aligned = where( ( sensors eq  2 ) or ( sensors eq  3 ) or $
                            ( sensors eq 28 ) or ( sensors eq 29 ), wc)
if (wc gt 0) then skewangle( field_aligned ) = 95.
skewangle = skewangle * radeg
for i = 0L, nsweeps-1 do $
  PA(*,i) = sgn(i) * ( sin(skewangle(*,i)) * sin_theta(i) * $
        ( sin_phi(i) * cos(encoder_angle1(i)*radeg + offset(sensors(*,i))) -   $
          cos_phi(i) * sin(encoder_angle1(i)*radeg + offset(sensors(*,i))) ) + $
          cos(skewangle(*,i)) * cos_theta(i))

PA = -1.0 > PA < 1.0
PA = acos(PA)/radeg

; flag UNKNOWN Pitch Angle of Unknown Sensors to 999.99
if (wbadc gt 0) then PA(bad_sensid) = 999.99

return, PA
end ; calc_PA_LAPI
