PRO filename_to_date_str, file_type, file_name, date_str, sc_id = sc_id

;Created: Mark Chutter, UNH
;July 25, 2001
;
;Modified:
;
;Calling Interface:
;file_type   char    (i)     Type of data as text (RDM, FTP)
;file_name   char    (i)     fully specified name of data file
;date_str    char    (o)     date of the form: 'DD-MMM-YYYY'
;
;Keywords:
;sc_id   if set, the sc_id is extracted from the filename and returned
;
;filename_to_date_str makes a date string of the form 'DD-MMM-YYYY'
;from the filename.  After using similar code so many times, I made a
;seperate routine to do this.

month_array  = ["Jan","Feb","Mar","Apr","May","Jun",$
                "Jul","Aug","Sep","Oct","Nov","Dec"]

name_parts = str_sep(file_name, '/')
num_parts = n_elements(name_parts)
short_name = name_parts[num_parts-1]
IF file_type EQ 'ftp' THEN BEGIN
    sc_id = strmid(short_name, 2, 1)
    date_time = strmid(short_name, 4)
    date = str_sep(date_time, 't')
    date_parts = str_sep(date[0], '-')
    date_str = date_parts[2] + '-' + month_array[date_parts[1]-1] + $
      '-' + date_parts[0]
ENDIF

IF file_type EQ 'rdm' OR file_type EQ 'msf' THEN BEGIN
    sc_id = strmid(short_name, 11, 1)
    year = strmid(short_name, 0, 2)
    month = strmid(short_name, 2, 2)
    day = strmid(short_name, 4, 2)
    date_str = day + '-' + month_array[month-1] + $
      '-20' + year   
ENDIF

END
