/******************************************************************************
                          openfile.cpp  -  description
                             -------------------
    begin                : Feb 14 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

******************************************************************************
$Log: openfile.cpp,v $
Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.4  2001/07/25 14:57:08  hav
new mode for opening files

Revision 1.3  2001/02/14 12:32:30  hav
common rcs format

Revision 1.2  2001/02/14 12:15:03  hav
stripped off old log entries

*****************************************************************************/

static char rcsid[] = "$Id: openfile.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $";

/********************** INCLUDE FILES ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "openfile.h"

/********************* FUNCTION DEFINITIONS *********************************/

/*==========================================================================*/
  FILE *OpenFile(const char *fn, int mode, int action)
/*==========================================================================*/
{
 FILE *fp;
 char mo[4];
 int platform;

 if (0) printf("%s\n", rcsid); //dummy instruction

 #if defined(__DECC)
    platform = OPF_DEC;
 #elif defined(__DECCXX)
    platform = OPF_DEC;
 #else
    platform = OPF_PC;
 #endif

 switch (mode) {
 case OPF_RT: strcpy(mo, platform==OPF_DEC ? "r" : "rt" ); break;
 case OPF_WT: strcpy(mo, platform==OPF_DEC ? "w" : "wt" ); break;
 case OPF_AT: strcpy(mo, platform==OPF_DEC ? "a" : "at" ); break;
 case OPF_RB: strcpy(mo, "rb"); break;
 case OPF_WB: strcpy(mo, "wb"); break;
 case OPF_AB: strcpy(mo, "ab"); break;
 case OPF_WBP:strcpy(mo, "wb+"); break;
 default:
    fprintf(stderr, "Openfile() : bad value of parameter 'mode' (%d)\n", mode);
    fprintf(stderr, "exiting...\n");
    exit(1);
    break;
 } /* endswitch */


 fp = fopen(fn, mo);

 if (fp==NULL && action == OPF_EXIT) {
    fprintf(stderr, "OpenFile(%s,...): ", fn);
    fflush(stdout);
    perror("");
    fprintf(stderr, "exiting...\n");
    exit(1);
 } /* endif */


 return fp;
}

