function sub_ctime, x, y

	; Subtract x(sec, microsec) - y(sec, microsec)
	; where x and y are ASSUMED to be equally dimensioned lonarr(2,*)
	; also allowed: x = arr(2,*), y = arr(2) 
        ; FURTHER ASSUMPTION: 0 le input-microsec le 999999
	;
	; return, z = x-y with microsec over/underflow properly handled

sx = size(x)
sy = size(y)
if(sy(0) eq 1) then begin
           yy = lonarr(sx(1),sx(2))
           yy(0,*) = y(0)
           yy(1,*) = y(1)
endif else yy = y
         
z =  x - yy

over = where(z(1,*) ge 1000000, c_o)
if(c_o gt 0) then begin
   z(0,over) = z(0,over) + 1L
   z(1,over) = z(1,over) - 1000000L
endif

under = where(z(1,*) lt 0, c_u)
if(c_u gt 0) then begin
   z(0,under) = z(0,under) - 1L
   z(1,under) = z(1,under) + 1000000L
endif

return, z
end	
