FUNCTION read_hk_packet, key_number, key_time
;
; read_hk_packet.pro
;
; created by: Mark Chutter, UNH
; Nov. 28, 2000
;
; Modified:
; Dec. 11, 2000 added to read only EDI HK from a MSF
; Jan.  5, 2001 MWC added data_stream for RDM and MSF
;
; Calling Interface:
; key_number P_LONG (i/o) Packet Type Search Key
; key_time   P_LONG (i/o) Packet Time Search Key
;
; Return Value:
;
; Affected Variables:
;
; Description:
; read_hk_packet will read through an EDI HK file that has been opened
; with pick_hk_init and return an EDI HK packet that meets the
; conditions set in the key_number and key_time.  This routine is not
; meant for reading MSF files when science data is also desired.

COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct
COMMON pick_hk, hk_file_type, pick_hk_lun
COMMON last_hk_record, last_hk_record
COMMON ctm_sat_id, ctm_sat_id

@pick_const

status = 0
packet_found = 0
packet_type = 1
right_mode = 0
good_data = -1
key_check = -1

; keep looking for a packet with good data of the type requested until
; one is found or eof
WHILE (good_data LT 1) DO BEGIN
    CASE hk_file_type OF
        'cdm':packet = cdm_get_packet(key_number, key_time)
        'rdm':packet = rdm_get_packet(key_number, key_time, $
                                      hk_file_type, pick_hk_lun)
        'msf':BEGIN ;msf files contain 3 different packets for each time
            ;SC HK first
            sun_data = rdm_get_packet(key_number, key_time, $
                                      hk_file_type, pick_hk_lun)
            ;EDI HK second
            packet = rdm_get_packet(key_number, key_time, $
                                    hk_file_type, pick_hk_lun)
            ;EDI SC third
            packet_sc = rdm_get_packet(key_number, key_time, $
                                       hk_file_type, pick_hk_lun)
        END
        'ctm':packet = ctm_get_packet(key_number, key_time)
    ENDCASE

    IF (packet.status EQ EOF) THEN BEGIN
        ; check to see if there was any data 
        rec_check = n_elements(last_hk_record)
        IF rec_check NE 0 THEN BEGIN
            record = last_hk_record
            record.status = EOF
            return, record
        ENDIF ELSE return, packet
    ENDIF
    
    ; try to read another packet if key conditions not met
    IF (packet.status LE 0) THEN BEGIN
        key_check = -1
    ENDIF ELSE key_check = 1
    
    IF (key_check GT 0) THEN BEGIN
        
        IF hk_file_type EQ 'cdm' THEN hk_record = hk_fill(packet.hk) $
        ELSE hk_record = hk_fill(packet.data)

        IF hk_record.status GT 0 THEN BEGIN
            good_data = 1
            hk_record.packet_type = PICK_HK_PACKET
            hk_record.packet_number = packet.packet_number
            hk_record.packet_time[0] = packet.packet_time[0]
            hk_record.packet_time[1] = packet.packet_time[1]
            hk_record.sc_id = packet.sc_id
            last_hk_record = hk_record

            ; this is byte 13 of the DDS header
            IF hk_file_type EQ 'rdm' OR $
              hk_file_type EQ 'msf' THEN $
              hk_record.data_stream = packet.data_stream
        ENDIF
    ENDIF                       ; key_check
ENDWHILE                        ; while (good_data < 1)

hk_record.status = packet_type
last_hk_record = hk_record
return, hk_record
END
