FUNCTION pickst_sc, mode_id, time_string, status, $
                   get_hk_data = get_hk_data 
; CLUSTER II IDL Procedure
;
; Abstract: Pick the data-value at the specified time
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; Modified by: 
; Mar. 18 1999 Mark Chutter added rdm data type
; Mar. 23, 1999 Mark Chutter added PICK_LIB environment variable
; Mar. 31, 1999 Mark Chutter added mode_id
; July 21, 1999 Mark Chutter added ctm; changed read_packet, replaced 
;                            CALL_EXTERNAL
; Apr. 21, 2000 Mark Chutter added msf file type
; Sep. 28, 2000 Mark Chutter return useful status
; Aug.  9, 2001 MWC added get_hk_data keyword
; Sep. 18, 2001 MWC add '@pick_const'
;         
; Calling Interface:
; mode_id	long	(i)	Science Mode
; time_string   char	(i)	Time at which to look for the data
; status	long	(o)	Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type SC_PICK_PCK_STRUCT
;
; Description:
; This function starts the PICKST_SC Module from the UNIX Pick Library
; and returns the received data in a structure.
;
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
;
; ...
; SR = PICKST_SC(sc_mode_enm1,"1995-MAR-02 10:00:00.00",PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; help, /struct, sr
; ...
;	
COMMON pick, file_type, pick_lun
@pick_const

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L

time_string = strupcase(time_string)
pick_cvt_str_sec, time_string, packet_time

mode_id = 2 ;mode_id of 2 means any science packet in read_rdm and read_cdm

IF keyword_set(get_hk_data) AND file_type NE 'msf' THEN BEGIN
    print, 'get_hk_data keyword can be used with MSF file type only'
    pick_error = {status: REQUEST_HK_FROM_NON_HK_DATA}
    return, pick_error
ENDIF

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num,  packet_time, $
                                    get_hk_data = get_hk_data)

    'ctm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num,  packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num,  packet_time)

ENDCASE

status = pick_record.status

return, pick_record

END  
