FUNCTION pickst_pk, mode_id, time_string, status 
; CLUSTER II IDL Procedure
;
; Abstract: Pick the data-value at the specified time
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; Nov. 22, 1998
;
; modified:
; Mar. 23, 1999 Mark Chutter added PICK_LIB environment variable
; Mar. 31, 1999 Mark Chutter added mode_id
; July 21, 1999 Mark Chutter added ctm; changed read_packet, replaced 
;                            CALL_EXTERNAL
; Apr. 21, 2000 Mark Chutter added msf file type
;
; Calling Interface:
; mode_id	long	(i)	Packet-type
; time_string   char	(i)	Time at which to look for the data
; status	long	(o)	Status of PICK-Operation (see PICK-Lib)
;
; Return Value:
; Structure of type SC_PICK_PCK_STRUCT
;
; Description:
; This function starts the PICKST_PK Module from the UNIX Pick Library
; and returns the received data in a structure.
; Call this function as: SR=PICKST_PK(<packet-id>,<time_string>,PSTATUS)
;
; Example:
; 
; PSTATUS = LONG(0)
; SMS     = ' '
;
; ...
; SR = PICKST_SC(sc_mode_enm1,"1995-MAR-02 10:00:00.00",PSTATUS)
; if not PSTATUS then begin
;   status=PICK_get_msg(PSTATUS,sms)
;   print,sms
; endif
; help, /struct, sr
; ...
;	
COMMON pick, file_type, pick_lun

packet_num = 0L
packet_time = lonarr(2)
packet_time[0] = 0L
packet_time[1] =  0L

time_string = strupcase(time_string)
pick_cvt_str_sec, time_string, packet_time
mode_id = 0 ;mode_id of 0 means any packet in read_rdm and read_cdm

IF file_type EQ '' THEN print, 'File type not set'

CASE file_type OF

    'cdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'rdm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'msf':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'ctm':pick_record = read_packet(mode_id, packet_num,  packet_time)

    'etm':pick_record = read_etm(mode_id, packet_num,  packet_time)

    'tlm':pick_record = read_tlm(mode_id, packet_num,  packet_time)

ENDCASE

return, pick_record

END  
