PRO PICK_CVT_STR_SEC, T_STRING, ATIME
; CLUSTER II IDL Procedure
;
; Abstract: Convert a time string into an atime structure (sec/1970, usec)
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; July 15, 1999
;
; modified:
; Aug. 11, 1999 MWC pick_cvt_str_sec now accepts strings that start
;                   either with the day or month or year
; Mar. 15, 2000 MWC only atime is allowed now (seconds and microseconds)
; June 12, 2000 MWC explicitly declare atime
; June 30, 2000 MWC now more forgiving if only one digit is used for
;                   day or hour
; Jul.  3, 2000 MWC now allows fraction of second to be left off of
;                   input
; Aug. 28, 2000 MWC Matthias pointed out that this did not work
;                   properly is the input string did not have 6 digits
;                   for the fraction of second
; Oct. 27, 2000 MWC 'Oct' is not equal to '0ct' (zero c t)
;
; Calling Interface:
; T_STRING	char	(i)	Timestring
; atime		lon(2)	(o)	atime array
;
; Description:
; pick_cvt_str_sec will convert a time string into an atime structure
; (sec/1970, usec).  The time string can be one of 3 formats:
; DD-MMM-YYYY HH:MM:SS.FFFFFF
; MMM-DD-YYYY HH:MM:SS.FFFFFF
; YYYY-MMM-DD HH:MM:SS.FFFFFF
; The F is for decimal portion of the seconds.  There can be from 1 to
; 6 F digits.  The other digits should be obvious.
day = -1
mon = ' '
year = -1
hour = -1
min = -1
sec = -1
msec = -1

month_array  = ["JAN","FEB","MAR","APR","MAY","JUN",$
                "JUL","AUG","SEP","OCT","NOV","DEC"]

atime = lonarr(2)

date_time = str_sep(t_string, ' ')
date = str_sep(date_time[0], '-')
dot_pos = strpos(date_time[1], '.')
IF dot_pos NE -1 THEN BEGIN
    time_frac = str_sep(date_time[1], '.')
    h_m_s = str_sep(time_frac[0], ':')
    ustr = '000000'
    strput,ustr,time_frac[1]
    usec = long(ustr)
    msec = usec/1000
ENDIF ELSE BEGIN
    h_m_s = str_sep(date_time[1], ':')
    usec = 0L
    msec = 0L
ENDELSE
hour = fix(h_m_s[0])
min = fix(h_m_s[1])
sec = fix(h_m_s[2])
; check to see if the string starts with the month or day or year
CASE strlen(date[0]) OF

    1: BEGIN ;in case the first field is the day with only one digit
        day = fix(date[0])
        mon = date[1]
        year = fix(date[2])
    END
    2: BEGIN ;day first
        day = fix(date[0])
        mon = date[1]
        year = fix(date[2])
    END
    3: BEGIN ;month first
        mon = date[0]
        day = fix(date[1])
        year = fix(date[2])
    END
    4: BEGIN ;year first
        year = fix(date[0])
        mon = date[1]
        day = fix(date[2])
    END

ENDCASE

IF '0CT' EQ strupcase(mon) THEN BEGIN
    print, 'Brett, try Oct, not 0ct'
    mon =  'OCT'
ENDIF

month = where(month_array eq strupcase(mon))+1

CDF_EPOCH,epoch_out, year, month[0], day, hour, min, sec, msec, /COMPUTE
CDF_EPOCH,epoch_unix,1970,1,1,0,0,0,0,/COMPUTE

atime[0] = long((epoch_out - epoch_unix) / 1000.)
atime[1] = usec


RETURN

END  
