PRO PICK_CVT_SEC_VAX, ATIME, T_STRING
; CLUSTER II IDL Procedure
;
; Abstract:  This function converts internal C time (seconds since 1-jan-1970) 
;            into a time string in VAX format (DD-MMM-YYYY hh:mm:ss.00).
;
; created by: Mark Chutter (based on a procedure by Kostantin Prokopui)
; July 15, 1999
;
; modified: 
; Nov. 21, 1999 MWC updated comments
; Mar. 15, 2000 MWC only atime is allowed now (seconds and microseconds)
;
; Calling Interface:
; atime		lon(2)	(i)	atime array
; T_STRING	char	(o)	Timestring
;
; Description:
; pick_cvt_sec_vax converts internal C time (seconds since 1-jan-1970) 
; into a time string in VAX format (DD-MMM-YYYY hh:mm:ss.00).  The second
; element of the input array can have up to 6 digits
day = -1
mon = ' '
year = -1
hour = -1
min = -1
sec = -1
msec = -1

month_array  = ["Jan","Feb","Mar","Apr","May","Jun",$
                "Jul","Aug","Sep","Oct","Nov","Dec"]
epoch_in = 0.d0
epoch_unix = 0.d0
CDF_EPOCH,epoch_unix,1970,1,1,0,0,0,0,/COMPUTE
epoch_in = epoch_unix + double(atime(0))*1000.d0
CDF_EPOCH,epoch_in, year, month, day, hour, min, sec, msec, /BREAK

; don't actually use the msec value, rather use the second element of
; atime which is microseconds
t_string = $
  string(format='(i2.2,"-",a3,"-",i4," ",i2.2,":",i2.2,":",i2.2,".",i6.6)', $
         day, month_array(month-1), year, hour, min, sec, atime[1])

RETURN

END  
