FUNCTION md_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI md data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Oct. 19, 1999 MWC used common block for structure definitions
; Aug.  3, 2000 MWC fixed byte order of longs
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added amb_geos struct
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esmd_struct structure is returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; md_fill fills an md data structure (sc_pick_esmd_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

md = sc_pick_esmd_struct
m = 0b

md.step = fix(sec_header[0]) * '100'x + fix(sec_header[1])
md.counts29_1 = long(sec_header[4]) * '1000000'xL + $
  long(sec_header[5]) * '10000'xL + $
  long(sec_header[2]) * '100'xL + $
  long(sec_header[3])
md.counts29_2 = long(sec_header[8]) * '1000000'xL + $
  long(sec_header[9]) * '10000'xL + $
  long(sec_header[6]) * '100'xL + $
  long(sec_header[7])
md.counts30_1 = long(sec_header[12]) * '1000000'xL + $
  long(sec_header[13]) * '10000'xL + $
  long(sec_header[10]) * '100'xL + $
  long(sec_header[11])
md.counts30_2 = long(sec_header[16]) * '1000000'xL + $
  long(sec_header[17]) * '10000'xL + $
  long(sec_header[14]) * '100'xL + $
  long(sec_header[15])
md.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

return, md
END
