FUNCTION m8_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI m8 data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Jan. 16, 2001 MWC changed names and split opt_oa into 2
; Feb.  5, 2001 MWC irchng is gone; ishort is now a word
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added amb_geos struct
; July 19, 2002 MWC changed most quantities to unsigned
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esm8_struct structure is returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; m8_fill fills an m8 data structure (sc_pick_esm8_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

m8 = sc_pick_esm8_struct

m8.fctmr = long(sec_header[0]) * '100'xL + long(sec_header[1])
m8.ranged_bmag = uint(sec_header[2]) * '100'x + uint(sec_header[3])
m8.fgm_rnot = uint(sec_header[4]) * '100'x + uint(sec_header[5])
m8.fgm_rchg = uint(sec_header[6]) * '100'x + uint(sec_header[7])
m8.xd1 = uint(sec_header[8]) * '100'x + uint(sec_header[9])
m8.yd1 = uint(sec_header[10]) * '100'x + uint(sec_header[11])
m8.beamcurrent_ref = uint(sec_header[12]) * '100'x + uint(sec_header[13])
m8.anode = uint(sec_header[14]) * '100'x + uint(sec_header[15])
m8.focus = uint(sec_header[16]) * '100'x + uint(sec_header[17])
m8.wehnelt = uint(sec_header[18]) * '100'x + uint(sec_header[19])
m8.fgm_ishort = uint(sec_header[20]) * '100'x + uint(sec_header[21])
m8.fgm_ilngf = uint(sec_header[22]) * '100'x + uint(sec_header[23])
m8.fgm_ilngb = uint(sec_header[24]) * '100'x + uint(sec_header[25])
m8.bci_short = uint(sec_header[26]) * '100'x + uint(sec_header[27])
m8.bci_bdata = uint(sec_header[28]) * '100'x + uint(sec_header[29])
m8.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

return, m8
END
