FUNCTION m13_fill, sec_header
; CLUSTER II IDL Function
;
; Abstract: fill an EDI m13 data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; Oct. 19, 1999 MWC used common block for structure definitions
; Jan. 27, 2000 MWC changed init_tbl to init_table
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Nov.  2, 2001 MWC replaced n_cone_steps with n_cone and fixed
;                   optics/energy table check
; Nov. 29, 2001 SSK trimmed first bit off optics and energy table
; Jan. 14, 2002 MWC added amb_geos struct
;
; Calling Interface:
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
; Return Value:
; A sc_pick_esm13_struct structure is returned.  If the error field is
; not zero, then the structure is not valid.
;
; Affected Variables:
;
; Description:
; m13_fill fills an m13 data structure (sc_pick_esm13_struct) from the
; secondary header of an EDI science packet according to the
; specifications of the EDI User's Manual

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

m13 = sc_pick_esm13_struct

m13.fctmr = fix(sec_header[0]) * '100'x + fix(sec_header[1])
m13.init_table = sec_header[2]
m13.type = sec_header[3]
m13.n_spin = sec_header[4]
m13.n_cone = sec_header[5]
m13.engy_start = sec_header[6]
m13.engy_end = sec_header[7]
m13.engy_step = sec_header[8]
m13.engy_shift = sec_header[9]
m13.engy_incr = fix(sec_header[10]) * '100'x + fix(sec_header[11])

IF (sec_header[12] AND '80'x) EQ 128  THEN $
  m13.optics_tbl = (fix(sec_header[12]) * '100'x + fix(sec_header[13])) $
                   AND '7FFF'x $
ELSE $
  m13.energy_tbl = fix(sec_header[12]) * '100'x + fix(sec_header[13])

m13.time_tag1 = long(sec_header[14]) * '100'xL + long(sec_header[15])
m13.pseudobx = fix(sec_header[16]) * '100'x + fix(sec_header[17])
m13.pseudoby = fix(sec_header[18]) * '100'x + fix(sec_header[19])
m13.pseudobz = fix(sec_header[20]) * '100'x + fix(sec_header[21])
m13.fgmx = fix(sec_header[22]) * '100'x + fix(sec_header[23])
m13.fgmy = fix(sec_header[24]) * '100'x + fix(sec_header[25])
m13.fgmz = fix(sec_header[26]) * '100'x + fix(sec_header[27])
m13.time_tag2 = long(sec_header[28]) * '100'xL + long(sec_header[29])
m13.valid = fix(sec_header[30]) * '100'x + fix(sec_header[31])

return, m13
END
