FUNCTION hk_fill, packet
; CLUSTER II IDL Function
;
; hk_fill.pro
;
; Created by: Mark Chutter, UNH
; Aug. 15, 1999
;
; Modified:
; Sep.  1, 1999 MWC I made this much more useful by convert the hex
;                   values to floats where needed.  I also tried to
;                   organize the HK data structure.
; Oct. 19, 1999 MWC added common block hk_structs
; Nov. 26, 2000 MWC add FGM range, Computed B mag, B cone angle, code
;                   type
; Nov. 28, 2000 MWC B cone angle was missing ()
; Dec.  8, 2000 MWC added variable section
; Dec. 15, 2000 MWC fixed B mag
; Jan. 22, 2000 MWC added optcs
; Sep. 10, 2001 MWC enrgy was never set until now
;
; Calling Interface:
; packet  byte  (i)  EDI housekeeping packet
;
; Return Value:
; A filled sc_pick_hk_struct
;
; Description:
; This file contains routines required to fill a EDI HK structure.
; This is not a user level function.
COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct
@pick_const

tmp = 0.
hk = sc_pick_hk_struct

hk.frcnt = uint(packet[0]) * '100'xu + uint(packet[1])
hk.i_v.conpc = $
  (float((packet[2] AND '0F'x) * '100'x + packet[3]) - 512.) * 0.4888
gdufix = 512. - hk.i_v.conpc * 0.716
hk.submo = ishft((packet[2] AND 'F0'x), -4)
hk.gdu1.gdpc = $
  (float((packet[4] AND '0F'x) * '100'x + packet[5]) - gdufix) * 0.4888
hk.gdu2.gdpc = $
  (float((packet[6] AND '0F'x) * '100'x + packet[7]) - gdufix) * 0.4888
hk.i_v.vol28 = ishft((packet[4] AND '10'x), -4)
hk.gdu1.gdol = ishft((packet[4] AND '20'x), -5)
hk.gdu2.gdol = ishft((packet[4] AND '40'x), -6)
hk.i_v.sol5v = ishft((packet[4] AND '80'x), -7)
hk.wrscm = ishft((packet[6] AND '20'x), -5)
hk.eewrp = ishft((packet[6] AND '40'x), -6)
hk.eepon = ishft((packet[6] AND '80'x), -7)
hk.crcnt = packet[8]
hk.cvcnt = packet[9]
hk.lastc = uint(packet[10]) * '100'x + uint(packet[11])
hk.sucoc = packet[13] AND '07'x
hk.sens1.pw24 = ishft((packet[13] AND '20'x), -5)
hk.gdu1.pw22 = ishft((packet[13] AND '40'x), -6)
hk.sens2.pw24 = ishft((packet[13] AND '08'x), -3)
hk.gdu2.pw22 = ishft((packet[13] AND '01'x), -4)
hk.hvdis = ishft((packet[13] AND '80'x), -7)
hk.modid = ishft((packet[12] AND 'FC'x), -2)
hk.gdu1.hvon = ishft((packet[12] AND '02'x), -1)
hk.gdu2.hvon = packet[12] AND '01'x

tmp = float(packet[14] * '100'x + packet[15])

case hk.sucoc OF

    0: hk.i_v.cur5v = (tmp - 512.) * 1.4664 
    1: hk.i_v.cu12v = (tmp - 512.) * 0.04888
    2: hk.i_v.cn12v = (tmp - 512.) * 0.04888 
    3: hk.i_v.acu5v = (tmp - float((packet[2] AND '0F'x) * '100'x + packet[3])) * (-0.04888)
    4: hk.i_v.vol5v = (tmp - 512.) * 0.01191
    5: hk.i_v.vo12v = (tmp - 512.) * 0.027696
    6: hk.i_v.vn12v = (tmp - 512.) * 0.027696
    7: hk.i_v.avo5v = (tmp - 512.) * 0.01873574

ENDCASE

even = hk.sucoc MOD 2
IF even EQ 0 THEN BEGIN
    hk.gdu1.gdu21 = uint(packet[16]) * '100'xu + uint(packet[17])
    hk.gdu1.gdu22 = uint(packet[18]) * '100'xu + uint(packet[19])
    hk.gdu1.gdu17 = uint(packet[20]) * '100'xu + uint(packet[21])
ENDIF ELSE BEGIN
    hk.gdu2.gdu21 = uint(packet[16]) * '100'xu + uint(packet[17])
    hk.gdu2.gdu22 = uint(packet[18]) * '100'xu + uint(packet[19])
    hk.gdu2.gdu17 = uint(packet[20]) * '100'xu + uint(packet[21])
ENDELSE

hk.gdu1.evt1 = uint(packet[22]) * '100'xu + uint(packet[23])
hk.gdu1.evt2 = uint(packet[24]) * '100'xu + uint(packet[25])
hk.gdu2.evt1 = uint(packet[26]) * '100'xu + uint(packet[27])
hk.gdu2.evt2 = uint(packet[28]) * '100'xu + uint(packet[29])

hk.gdu1.mcad = ishft((packet[30] AND 'F0'xb), -4)
hk.gdu1.mcrr = (fix(packet[30]) AND '0F'x) * '100'x + fix(packet[31])
hk.gdu2.mcad = ishft((packet[32] AND 'F0'xb), -4)
hk.gdu2.mcrr = (fix(packet[32]) AND '0F'x) * '100'x + fix(packet[33])

hk.chksu = packet[34]
hk.pllst = packet[35]
hk.bmagn = uint(packet[36]) * '100'x + uint(packet[37])
hk.fgmr = ishft((uint(packet[36]) AND '70'x), -4)
CASE hk.fgmr OF
    2:range_fac = 32.
    3:range_fac = 8.
    4:range_fac = 2.
    5:range_fac = 0.5
    7:range_fac = 0.03125 ;1/32
    ELSE:range_fac = 1000.0 ;make Bmag very small
ENDCASE
hk.bmag = ((uint(packet[36]) AND 'F'x) * '100'x + uint(packet[37])) / range_fac
; vasec to decide how to proceed
hk.vasec = ishft((packet[38] AND '0C'x), -2)

IF (hk.vasec NE 3) THEN BEGIN

    hk.gdchs = packet[39] AND '3F'x
    hk.gdsel = ishft((packet[39] AND '80'x), -7)
    hk.sens1.stps = packet[38] AND '01'x
    hk.sens2.stps = ishft((packet[38] AND 2), -1)
    hk.gdset = ishft((packet[38] AND '30'x), -4)
    hk.pgacf = ishft((packet[38] AND 'C0'x), -6)
    
ENDIF

IF (hk.vasec EQ 3) THEN BEGIN
    
    hk.sens1.stps = packet[38] AND '01'x
    hk.sens2.stps = ishft((packet[38] AND 2), -1)
    hk.gdset = ishft((packet[38] AND '30'x), -4)
    hk.pgacf = ishft((packet[38] AND 'C0'x), -6)
    hk.ramad = long(packet[39]) * '10000'x + $
      long(packet[40]) * '100'x + $
      long(packet[41])
    ram_start = 50
    FOR i = 0, 15 DO BEGIN
        hk.ram[i] = (uint(packet[ram_start+2*i]) AND '7F'x) * '100'x + $
          uint(packet[ram_start+2*i+1])
    ENDFOR
ENDIF

s1mx1 = ishft(byte(packet[44] AND 'E0'xb), -5)
sensor = sensor_fill(packet[42], s1mx1)
hk.sens1.mx1 = sensor
s1mx2 = ishft(byte(packet[44] AND '1C'xb), -2)
sensor = sensor_fill(packet[43], s1mx2)
hk.sens1.mx2 = sensor
s2mx1 = ishft(byte(packet[48] AND 'E0'xb), -5)
sensor = sensor_fill(packet[46], s2mx1)
hk.sens2.mx1 = sensor
s2mx2 = ishft(byte(packet[48] AND '1C'xb), -2)
sensor = sensor_fill(packet[47], s2mx2)
hk.sens2.mx2 = sensor

hk.sens1.dgtl.disa = byte(packet[44]) AND '01'x
hk.sens2.dgtl.disa = byte(packet[48]) AND '01'x
hk.sens1.dgtl.ovrf = ishft(byte(packet[44]) AND '02'x, -1)
hk.sens2.dgtl.ovrf = ishft(byte(packet[48]) AND '02'x, -1)

;  IF ((hk.stmp1 NE 'FF'x) AND (hk.stmp2 NE 'FF'x))
IF ((hk.sucoc EQ 0) OR (hk.sucoc EQ 4)) THEN BEGIN
    hk.sens1.dgtl.basa = byte(packet[45])
    hk.sens2.dgtl.basa = byte(packet[49])
ENDIF ELSE IF ((hk.sucoc EQ 1) OR (hk.sucoc EQ 5)) THEN BEGIN
    hk.sens1.dgtl.acpo = byte(packet[45])
    hk.sens2.dgtl.acpo = byte(packet[49])
ENDIF ELSE IF ((hk.sucoc EQ 2) OR (hk.sucoc EQ 6)) THEN BEGIN
    hk.sens1.dgtl.copo = byte(packet[45])
    hk.sens2.dgtl.copo = byte(packet[49])
ENDIF ELSE IF ((hk.sucoc EQ 3) OR (hk.sucoc EQ 7)) THEN BEGIN
    hk.sens1.dgtl.pwst = ishft((byte(packet[45]) AND '80'x), -7)
    hk.sens1.dgtl.dtim = ishft((byte(packet[45]) AND '70'x), -4)
    hk.sens1.dgtl.exim = ishft((byte(packet[45]) AND '04'x), -2)
    hk.sens1.dgtl.swap = ishft((byte(packet[45]) AND '02'x), -1)
    hk.sens1.dgtl.tpls = byte(packet[45]) AND '01'x
    hk.sens2.dgtl.pwst = ishft((byte(packet[49]) AND '80'x), -7)
    hk.sens2.dgtl.dtim = ishft((byte(packet[49]) AND '70'x), -4)
    hk.sens2.dgtl.exim = ishft((byte(packet[49]) AND '04'x), -2)
    hk.sens2.dgtl.swap = ishft((byte(packet[49]) AND '02'x), -1)
    hk.sens2.dgtl.tpls = byte(packet[49]) AND '01'x
ENDIF

IF hk.gdsel EQ 0 THEN BEGIN
    CASE hk.gdset OF
        0: hk.gdu1.gdu_01 = gdu_01_fill(packet[50:81])
        1: hk.gdu1.gdu_23 = gdu_23_fill(packet[50:81])
        2: hk.gdu1.gdu_45 = gdu_45_fill(packet[50:81])
        3: hk.gdu1.gdu_67 = gdu_67_fill(packet[50:81])
    ENDCASE
ENDIF ELSE BEGIN
    CASE hk.gdset OF
        0: hk.gdu2.gdu_01 = gdu_01_fill(packet[50:81])
        1: hk.gdu2.gdu_23 = gdu_23_fill(packet[50:81])
        2: hk.gdu2.gdu_45 = gdu_45_fill(packet[50:81])
        3: hk.gdu2.gdu_67 = gdu_67_fill(packet[50:81])
    ENDCASE
ENDELSE

;bcone = Bx / Bmag, according to Barb
hk.bcone = acos((fix(packet[82]) * '100'x + fix(packet[83]))/512.)*!radeg
hk.cdtyp = ishft(fix(packet[84] AND '80'x), -7)
hk.despn = ishft(fix(packet[84] AND '10'x), -4)
hk.optcs = fix(packet[84]) AND '7'x
hk.enrgy = ishft(fix(packet[84] AND '40'x), -6)
hk.intbl = fix(packet[85])
IF hk.intbl NE 'FF'x THEN BEGIN
    CASE (hk.intbl AND 'F'x) OF
        'E'x:hk.nsamp = 2
        'F'x:hk.nsamp = 2
        '0'x:hk.nsamp = 2
        '1'x:hk.nsamp = 2
        'A'x:hk.nsamp = 4
        'B'x:hk.nsamp = 4
        'C'x:hk.nsamp = 4
        'D'x:hk.nsamp = 4
        ELSE:hk.nsamp = 0
    ENDCASE
    CASE (hk.intbl AND 'F0'x) OF
        '5'x:hk.extrp = 1
        '6'x:hk.extrp = 1
        ELSE:hk.extrp = 0
    ENDCASE
ENDIF
hk.pacmo = uint(packet[89]) AND '7'x
hk.extrp = ishft(fix(packet[89] AND '80'x), -7)
hk.status = 1

IF hk.submo EQ 0 THEN hk.status = HK_ERROR

return, hk

END

