PRO get_srp, sun_data, n_srp, srp, srp1
;
;  get_srp.pro
;
;  created by: Mark Chutter, UNH
;  Mar. 15, 2000
;
;  Modified:
;
;  Calling Interface:
;  sun_data rdm       (i) sun data from shk packet
;  n_srp    int       (o) number of Sun Reference Pulses
;  srp      lonarr(2) (o) atime of first pulse
;  srp1     lonarr(2) (o) atime of second pulse
;
;  Affected Variables:

;  Description:
;  get_srp determines that time of the Sun Reference Pulses (up to 2
;  per packet) based on the description in DS-QMW-TN-007.

srp = lonarr(2)
srp1 = lonarr(2)
srp_ray = dblarr(12)

FOR i = 0, 11 DO BEGIN
    IF (uint(sun_data.data[i*3]) AND '10'xu) EQ '10'xu THEN BEGIN
        ticks = ulong(sun_data.data[i*3] AND 'F'xul) * '10000'xul + $
          ulong(sun_data.data[i*3+1]) * '100'xul + $
          ulong(sun_data.data[i*3+2])
        srp_ray[i] = -10.304443052D + double(ticks)/131072.D
    ENDIF
ENDFOR
w = where(srp_ray LT 0., n_srp)

IF n_srp GE 1 THEN BEGIN
    srp[0] = sun_data.packet_time[0] + long(srp_ray(w[0]))
    srp[1] = sun_data.packet_time[1] + $
      long((srp_ray(w[0]) - long(srp_ray(w[0]))) * 1000000)

    IF srp[1] GE 1000000 THEN BEGIN
        srp[1] = srp[1] - 1000000
        srp[0] = srp[0] + 1
    ENDIF
    IF srp[1] LT 0 THEN BEGIN
        srp[1] = srp[1] + 1000000
        srp[0] = srp[0] - 1
    ENDIF
ENDIF
IF n_srp EQ 2 THEN BEGIN
    srp1[0] = sun_data.packet_time[0] + long(srp_ray(w[1]))
    srp1[1] = sun_data.packet_time[1] + $
      long((srp_ray(w[1]) - long(srp_ray(w[1]))) * 1000000)

    IF srp1[1] GE 1000000 THEN BEGIN
        srp1[1] = srp1[1] - 1000000
        srp1[0] = srp1[0] + 1
    ENDIF
    IF srp1[1] LT 0 THEN BEGIN
        srp1[1] = srp1[1] + 1000000
        srp1[0] = srp1[0] - 1
    ENDIF
ENDIF

END
