FUNCTION gdu_23_fill, vasec
; CLUSTER II IDL Function
;
; gdu_23_fill
;
; created by: Mark Chutter, UNH
; Aug. 16, 1999
;
; Modified:
; Sep.  1, 1999 I Made this much more useful by convert the hex
;               values to floats where needed.
; MWC Oct. 19, 1999 MWC added common block hk_structs
; July 11, 2002 MWC renamed 5v1f 5vif
;
; Calling Interface:
; vasec  byte  (i)  raw GDU HK parameters from group 2 and 3
;
; Return Value:
; A filled sc_pick_gdu_23_struct
;
; Description:
; This file contains routines required to fill GDU HK
; parameters from Groups 2 and 3
COMMON hk_structs, sc_pick_ana_sensor_struct, sc_pick_dig_sensor_struct, sc_pick_sensor_struct, sc_pick_gdu_01_struct, sc_pick_gdu_23_struct, sc_pick_gdu_45_struct, sc_pick_gdu_67_struct, sc_pick_gdu_struct, sc_pick_I_V_struct, sc_pick_hk_struct

gdu_23 = sc_pick_gdu_23_struct

gdu_23.vs28 = float(fix(vasec[0]) * '100'x + fix(vasec[1])) * 0.012875
gdu_23.v5uf = float(fix(vasec[2]) * '100'x + fix(vasec[3])) * 0.003125
gdu_23.p5vc = float(fix(vasec[4]) * '100'x + fix(vasec[5])) * 0.003125
gdu_23.gnd0 = float(fix(vasec[6]) * '100'x + fix(vasec[7])) *  0.000625
gdu_23.n5vc = float(fix(vasec[8]) * '100'x + fix(vasec[9])) * 0.003125
gdu_23.v5if = float(fix(vasec[10]) * '100'x + fix(vasec[11])) * 0.003125
gdu_23.v5p1 = float(fix(vasec[12]) * '100'x + fix(vasec[13])) * 0.003125
gdu_23.v5p2 = float(fix(vasec[14]) * '100'x + fix(vasec[15])) * 0.003125
gdu_23.gpux = float(fix(vasec[16]) * '100'x + fix(vasec[17])) * 0.000625
gdu_23.gnux = float(fix(vasec[18]) * '100'x + fix(vasec[19])) * 0.000625
gdu_23.gpuy = float(fix(vasec[20]) * '100'x + fix(vasec[21])) * 0.000625
gdu_23.gnuy = float(fix(vasec[22]) * '100'x + fix(vasec[23])) * 0.000625
gdu_23.g_an = float(fix(vasec[24]) * '100'x + fix(vasec[25])) * 0.000625
gdu_23.g_fc = float(fix(vasec[26]) * '100'x + fix(vasec[27])) * 0.000625
gdu_23.g_ca = float(fix(vasec[28]) * '100'x + fix(vasec[29])) * 0.000625
gdu_23.g_bw = float(fix(vasec[30]) * '100'x + fix(vasec[31])) * 0.000625

return, gdu_23 
END
