FUNCTION gd_one_fill, bci_buf, data_count, max_data_size, mode, $
                      sc_id, packet_time, which_det
; CLUSTER II IDL Function
;
; Abstract: fill an EDI gd data structure for one detector mode
;
; Created by: Mark Chutter, UNH 
; June 28, 2002
;
; Modified:
; Oct. 10, 2002 MWC the quality bits were reversed for which_det = 1
; Oct. 16, 2002 MWC set q=0 where gun voltages=0
;
; Calling Interface:
; bci_buf       bytarr  (i) buffer containing packet gd data
; data_count    int     (i) number of data collected
; max_data_size int     (i) maximum number of data in packet
; mode          int     (i) determines whether the packet is nominal 1, 
;                           pacmo 5 or burst 1, pacmo 1.
; which_det     byte    (i) 0 means detector 1
;
; Return Value:
; If the input requirements are met, a sc_pick_gd_struct structure
; is returned.  Otherwise an integer status is returned.
;
; Affected Variables:
;
; Description:
; gd_one_fill fills all the gd structures for one detector mode in NM1, PM5 or
; BM11, PMpacket.  When which_det = 0, the "last" quantities are
; stored first; when which_det = 1, the "next-to-last" quantities come
; first.  This is not a user level function.

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

BPACMO1_DATA_SIZE = 20

n_out = bytarr(8)
n_out = [1,2,4,8,8,16,32,64]

gd = replicate({sc_pick_gd_struct}, max_data_size) 

index1 = indgen(data_count/2)
offset1 = index1 * BPACMO1_DATA_SIZE
index2 = indgen(data_count/2) + data_count/2
offset2 = index2 * BPACMO1_DATA_SIZE

; nnn should be the same for index[12]
gd[index1].nnn = n_out[ishft((bci_buf[offset1[index1]+6] AND '70'x), -4)]
gd[index2].nnn = gd[index1].nnn

tmp = (long(bci_buf[offset1[index1]] AND '0F'x) * '100'x + $
       long(bci_buf[offset1[index1]+1])) 

gd[index1].t1 = tmp * gd[index1].nnn
w_o = where(tmp EQ 'FFF'x, count_o)
IF count_o GT 0 THEN gd[w_o].tof_over = 1

;t1m2 is signed
sign = bci_buf[offset1[index1]] AND '20'x
tmp = ishft(fix(bci_buf[offset1[index1]] AND '10'x), -4) * '100'x + $
  fix(bci_buf[offset1[index1]+2] AND 'F0'x) + $
  ishft(fix(bci_buf[offset2[index1]+4] AND 'F0'x), -4)
w_p = where(tmp EQ '1FF'x AND sign EQ '0'x, count_p)
IF count_p GT 0 THEN gd[w_p+data_count/2].dtof_p_over = 1

w_n = where(tmp EQ '000'x AND sign EQ '20'x, count_n)
IF count_n GT 0 THEN gd[w_n+data_count/2].dtof_n_over = 1

w = where(sign EQ '20'x, count)
IF count GT 0 THEN tmp[w] = tmp[w] - '200'x

t1m2 = tmp * gd[index2].nnn
gd[index2].t1 = gd[index1].t1 - t1m2

; m should be the same for index[12]
gd[index1].m = ishft((bci_buf[offset1[index1]] AND 'C0'x), -6)
gd[index2].m = gd[index1].m

IF which_det EQ 0 THEN BEGIN
    gd[index1].vax2 = (fix(bci_buf[offset1[index1]+2] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+3])) * 8
    gd[index1].vay2 = (fix(bci_buf[offset1[index1]+4] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+5])) * 8
    gd[index2].vax2 = (fix(bci_buf[offset1[index1]+6] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+7])) * 8
    gd[index2].vay2 = (fix(bci_buf[offset1[index1]+8] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+9])) * 8
    gd[index1].sq1 = fix(ishft((bci_buf[offset1[index1]+8] AND 'C0'x), -6))
    gd[index2].sq1 = fix(ishft((bci_buf[offset1[index1]+8] AND '30'x), -4))
ENDIF ELSE BEGIN
    gd[index1].vax1 = (fix(bci_buf[offset1[index1]+2] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+3])) * 8
    gd[index1].vay1 = (fix(bci_buf[offset1[index1]+4] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+5])) * 8
    gd[index2].vax1 = (fix(bci_buf[offset1[index1]+6] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+7])) * 8
    gd[index2].vay1 = (fix(bci_buf[offset1[index1]+8] AND '0F'x) * '100'x + $
                       fix(bci_buf[offset1[index1]+9])) * 8
    gd[index2].sq2 = fix(ishft((bci_buf[offset1[index1]+8] AND 'C0'x), -6))
    gd[index1].sq2 = fix(ishft((bci_buf[offset1[index1]+8] AND '30'x), -4))
ENDELSE

;rarely EDI gets gun voltages=0, but q > 0
w_1 = where(gd.vax2 EQ 0 AND gd.vay2 EQ 0 AND gd.sq1 GT 0, zero_1)
IF zero_1 GT 0 THEN gd[w_1].sq1 = 0
w_2 = where(gd.vax1 EQ 0 AND gd.vay1 EQ 0 AND gd.sq2 GT 0, zero_2)
IF zero_2 GT 0 THEN gd[w_2].sq2 = 0

; e should be the same for index[12]
gd[index1].e = ishft((bci_buf[offset1[index1]+6] AND '80'x), -7)
gd[index2].e = gd[index1].e

IF which_det EQ 0 THEN BEGIN
;word 15 is ALL
    gd[index1].word15_1 = $
      uint(bci_buf[offset1[index1]+12] AND '3F'x) * '100'x + $
      uint(bci_buf[offset1[index1]+13])
    gd[index2].word15_1 = $
      uint(bci_buf[offset1[index1]+16] AND '3F'x) * '100'x + $
      uint(bci_buf[offset1[index1]+17])
;word 14 is SMAX +/-, only the lower 12 bits are used
    gd[index1].word14_1 = $
      fix(bci_buf[offset1[index1]+10] AND '3F'x) * '100'x + $
      fix(bci_buf[offset1[index1]+11])
    w = where((bci_buf[offset1[index1]+10] AND '20'x) GT 0, count)
    IF count GT 0 THEN BEGIN
        gd[index1[w]].word14_1 = gd[index1[w]].word14_1 - '4000'x
    ENDIF
    gd[index2].word14_1 = $
      fix(bci_buf[offset1[index1]+14] AND '3F'x) * '100'x + $
      fix(bci_buf[offset1[index1]+15])
    w = where((bci_buf[offset2[index2]+14] AND '20'x) GT 0, count)
    IF count GT 0 THEN BEGIN
        gd[index2[w]].word14_1 = gd[index2[w]].word14_1 - '4000'x
    ENDIF
ENDIF ELSE BEGIN
;word 15 is ALL
    gd[index1].word15_2 = $
      uint(bci_buf[offset1[index1]+12] AND '3F'x) * '100'x + $
      uint(bci_buf[offset1[index1]+13])
    gd[index2].word15_2 = $
      uint(bci_buf[offset1[index1]+16] AND '3F'x) * '100'x + $
      uint(bci_buf[offset1[index1]+17])
;word 14 is SMAX +/-, only the lower 12 bits are used
    gd[index1].word14_2 = $
      fix(bci_buf[offset1[index1]+10] AND '3F'x) * '100'x + $
      fix(bci_buf[offset1[index1]+11])
    w = where((bci_buf[offset1[index1]+10] AND '20'x) GT 0, count)
    IF count GT 0 THEN BEGIN
        gd[index1[w]].word14_2 = gd[index1[w]].word14_2 - '4000'x
    ENDIF
    gd[index2].word14_2 = $
      fix(bci_buf[offset1[index1]+14] AND '3F'x) * '100'x + $
      fix(bci_buf[offset1[index1]+15])
    w = where((bci_buf[offset2[index2]+14] AND '20'x) GT 0, count)
    IF count GT 0 THEN BEGIN
        gd[index2[w]].word14_2 = gd[index2[w]].word14_2 - '4000'x
    ENDIF
ENDELSE

IF which_det EQ 0 THEN BEGIN
    gd[index1].max_addr1 = $
      ishft((bci_buf[offset1[index1]+10] AND 'C0'x), -4) + $
      ishft((bci_buf[offset1[index1]+12] AND 'C0'x), -6)
    gd[index2].max_addr1 = $
      ishft((bci_buf[offset1[index1]+14] AND 'C0'x), -4) + $
      ishft((bci_buf[offset1[index1]+16] AND 'C0'x), -6)
    
    gd[index1].i1 = bci_buf[offset1[index1]+18] AND '3F'x
    gd[index2].i1 = bci_buf[offset1[index1]+19] AND '3F'x
    
    gd[index1].frame1 = ishft((bci_buf[offset1[index1]+18] AND 'C0'x), -6)
    gd[index2].frame1 = ishft((bci_buf[offset1[index1]+19] AND 'C0'x), -6)
ENDIF ELSE BEGIN
    gd[index1].max_addr2 = $
      ishft((bci_buf[offset1[index1]+10] AND 'C0'x), -4) + $
      ishft((bci_buf[offset1[index1]+12] AND 'C0'x), -6)
    gd[index2].max_addr2 = $
      ishft((bci_buf[offset1[index1]+14] AND 'C0'x), -4) + $
      ishft((bci_buf[offset1[index1]+16] AND 'C0'x), -6)
    
    gd[index1].i2 = bci_buf[offset1[index1]+18] AND '3F'x
    gd[index2].i2 = bci_buf[offset1[index1]+19] AND '3F'x
    
    gd[index1].frame2 = ishft((bci_buf[offset1[index1]+18] AND 'C0'x), -6)
    gd[index2].frame2 = ishft((bci_buf[offset1[index1]+19] AND 'C0'x), -6)
ENDELSE

return, gd
END
