FUNCTION edi_sec_header_fill, mode, sec_header_buf
; CLUSTER II IDL Function
;
; Abstract: fill an edi header data structure
;
; Created by: Mark Chutter, UNH 
; July 1, 1999
;
; Modified:
; July 21, 1999 Mark Chutter Added mode 11
; Aug.  9, 1999 MWC changed error field to status
; Oct. 14, 1999 MWC IDL was changing the "tm valid" word from a signed integer
;                   into a long when written as 'A76F'x.  Now I just
;                   use -22673 instead.
; Oct. 19, 1999 MWC used common block for structure definitions
; Jul.  5, 2000 MWC was checking wrong bit for bx stepping (m1dgx)
; Aug. 21, 2000 MWC added fctmr to secondary header
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; Jan. 14, 2002 MWC added ambient GEOS
; Nov. 26, 2003 MWC the good data word is A76E when EDI is operating
;                   from RAM and A76F when operation out of PROM
; 
; Calling Interface:
; mode           int    (i) science mode of the EDI science packet
; sec_header_buf bytarr (i) secondary header of the EDI science packet 
;
;
; Return Value:
; If the input requirements are met, an EDI secondary header structure
; is returned.  Otherwise an integer status is returned.
;
; Affected Variables:
;
; Description:
; edi_sec_header_fill extracts the data specified in the EDI User's Manual
; from the secondary header (bytes 8-39) and fills the appropriate data 
; structure depending on the science mode

COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

valid = 0
bx_stepping = 0b

sec_header = sc_pick_eshd_struct
CASE mode OF

    '8'x:BEGIN
        m8 = m8_fill(sec_header_buf)
        sec_header.m8 = m8
        IF (sec_header.m8.valid EQ -22673) OR $
          (sec_header.m8.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
            sec_header.fctmr = m8.fctmr
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    'c'x:BEGIN
        mc = mc_fill(sec_header_buf)
        sec_header.mc = mc
        IF (sec_header.mc.valid EQ -22673) OR $
          (sec_header.mc.valid EQ -22674) THEN BEGIN
          sec_header.status = 1
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    'd'x:BEGIN
        md = md_fill(sec_header_buf)
        sec_header.md = md
        IF (sec_header.md.valid EQ -22673) OR $
          (sec_header.md.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    '1'x:BEGIN ;if init table is something other than 0,1,2 or 4 it is GEOS
        IF ((sec_header_buf[2] EQ 0) OR $
            (sec_header_buf[2] EQ 1) OR $
            (sec_header_buf[2] EQ 2) OR $
            (sec_header_buf[2] EQ 4)) THEN BEGIN
            m1 = m1_fill(sec_header_buf)
            sec_header.m1 = m1
            IF (sec_header.m1.valid EQ -22673) OR $
              (sec_header.m1.valid EQ -22674) THEN BEGIN
                sec_header.status = 1
                sec_header.fctmr = m1.fctmr
            ENDIF ELSE sec_header.status = INVALID_EDI_DATA
        ENDIF ELSE BEGIN
                                ;Use bit 1 of flag bits to determine
                                ;which option of diagnostic GEOS has
                                ;been selected (if set: xdyd option) 
            bx_stepping = sec_header_buf[11] AND '2'x
            IF bx_stepping EQ 0 THEN BEGIN
                m1dgx = m1dgx_fill(sec_header_buf)
                sec_header.m1dgx = m1dgx
                IF (sec_header.m1dgx.valid EQ -22673) OR $
                  (sec_header.m1dgx.valid EQ -22674) THEN BEGIN
                    sec_header.status = 1
                    sec_header.fctmr = m1dgx.fctmr
                ENDIF ELSE sec_header.status = INVALID_EDI_DATA
            ENDIF ELSE BEGIN 
                m1dgb = m1dgb_fill(sec_header_buf)
                sec_header.m1dgb = m1dgb
                IF (sec_header.m1dgb.valid EQ -22673) OR $
                  (sec_header.m1dgb.valid EQ -22674) THEN BEGIN
                    sec_header.status = 1
                    sec_header.fctmr = m1dgb.fctmr
                ENDIF ELSE sec_header.status = INVALID_EDI_DATA
            ENDELSE
        END
    END

    '2'x:BEGIN
        m1 = m1_fill(sec_header_buf)
        sec_header.m1 = m1
        IF (sec_header.m1.valid EQ -22673) OR $
          (sec_header.m1.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
            sec_header.fctmr = m1.fctmr
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    '5'x:BEGIN
        m5 = m5_fill(sec_header_buf)
        sec_header.m5 = m5
        IF (sec_header.m5.valid EQ -22673) OR $
          (sec_header.m5.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
            sec_header.fctmr = m5.fctmr
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    '11'x:BEGIN
        m1 = m1_fill(sec_header_buf)
        sec_header.m1 = m1
        IF (sec_header.m1.valid EQ -22673) OR $
          (sec_header.m1.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    '13'x:BEGIN
        m13 = m13_fill(sec_header_buf)
        sec_header.m13 = m13
        IF (sec_header.m13.valid EQ -22673) OR $
          (sec_header.m13.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
            sec_header.fctmr = m13.fctmr
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END

    '15'x:BEGIN ;ambient GEOS
        m1 = m1_fill(sec_header_buf)
        sec_header.m1 = m1
        IF (sec_header.m1.valid EQ -22673) OR $
          (sec_header.m1.valid EQ -22674) THEN BEGIN
            sec_header.status = 1
        ENDIF ELSE sec_header.status = INVALID_EDI_DATA
    END
ENDCASE

return, sec_header
END
