FUNCTION edi_header_fill, packet, packet_number, packet_time
; CLUSTER II IDL Function
;
; Abstract: fill an edi header data structure
;
; Created by: Mark Chutter, UNH 
; June 30, 1999
;
; modified:
; Aug. 12, 1999 MWC set status to 1
; Oct. 19, 1999 MWC used common block for structure definitions
; June 12, 2000 MWC added mem_dump_bit
; Sep.  8, 2000 MWC mem_dump_bit was not getting set properly
; Nov. 27, 2000 MWC was checking wrong bit to see whether Staff or extrap
; Feb. 10, 2001 MWC now sub_mode is set to 1 for 2, 3, 4, or 6
; Apr.  3, 2001 MWC changed pick_struct COMMON block because of the
;                   addition of pacmo4
; June  6, 2001 MWC added check to fix TM for May 31 - June 1, 2001
; July  2, 2001 MWC added check for having BM1 and PM 5 which aint
;                    valid
; Aug. 20, 2001 MWC added VERBOSE ENV variable and check for corrupted
;                   BM1 data on June 7, 13, and 17, 2001
; Jan. 14, 2002 MWC added sc_pick_amb_geos_struct
; June 27, 2002 MWC added bytes to sc_pick_ehdr_struct for one detector
;                   mode and which detector
; Oct.  2, 2002 MWC added check for science mode = 5, pacmo = 0
; July 13, 2004 MWC EDI was incorrectly command to use PACMO 11 with
;                   WW, so packets with science mode of 5 and PACMO of
;                   something other than 1 or 5 are flagged as invalid.
;
; Calling Interface:
; packet        bytarr    (i) an EDI science packet
; packet_number long      (i) EDI packet number
; packet_time   lonarr(2) (i) time of EDI packet
;
; Return Value:
; If the input requirements are met, an EDI header structure is returned.
; Otherwise an integer status is returned.
;
; Affected Variables:
;
; Description:
; edi_header_fill extracts the data specified in the EDI User's Manual
; from the header (bytes 0-7) and fills an edi header structure
; (sc_pick_ehdr_struct)
COMMON pick_structs, $
  sc_pick_ehdr_struct, $
  sc_pick_eshd_struct, $
  sc_pick_esm8_struct, sc_pick_esmc_struct, sc_pick_esmd_struct, $
  sc_pick_esm1_struct, sc_pick_esm1dgx_struct, sc_pick_esm1dgb_struct, $
  sc_pick_esm5_struct, sc_pick_esm11_struct, sc_pick_esm13_struct, $
  sc_pick_dfgm_struct, sc_pick_amb_geos_struct, $
  sc_pick_gd_struct, sc_pick_bci16_struct, $
  sc_pick_npacmo5_struct, sc_pick_npacmo4_struct, sc_pick_npacmo2_struct, $
  sc_pick_npacmo1_struct, sc_pick_npacmo0_struct, $
  sc_pick_bpacmo4_struct, sc_pick_bpacmo1_struct, sc_pick_bpacmo0_struct, $
  sc_pick_enm_struct, sc_pick_ebm1_struct, sc_pick_ebm3_struct, $
  sc_pick_pck_struct, sc_pick_headers_struct

@pick_const

verbose = getenv('PICK_VERBOSE')

header = sc_pick_ehdr_struct
header.packet_number = packet_number
header.packet_time[0] = packet_time[0]
header.packet_time[1] = packet_time[1]
header.mem_dump_bit = (packet[0] AND '80'x)
header.pgai_conf = packet[0] AND '40'x
header.pga1_conf = packet[0] AND '20'x
header.pga2_conf = packet[0] AND '10'x
sub_mode = packet[1] AND '7'x
CASE sub_mode of
    2: header.sub_mode = 1
    3: header.sub_mode = 1
    4: header.sub_mode = 1
    6: header.sub_mode = 1
    ELSE: header.sub_mode = sub_mode
ENDCASE
IF header.sub_mode EQ 1 THEN BEGIN
    header.chan0_comp = packet[0] AND '8'x
    header.chan1_accum =  packet[0] AND '4'x
ENDIF
IF header.sub_mode EQ 5 THEN BEGIN
    header.chan2_comp =  packet[0] AND '8'x
    header.chan3_comp =  packet[0] AND '4'x
ENDIF
header.one_det = (packet[0] AND '1'x)
header.which_det = ishft((packet[0] AND '2'x), -1)

header.science_mode = ishft((packet[1] AND 'F8'x), -3)
IF header.science_mode EQ 0 THEN $
  header.wbp_cntr = long(packet[2]) * '100'x + long(packet[3]) $
ELSE BEGIN
    header.wbp_cntr = long(packet[3])
    header.peace_cnt_gun1 = ishft(fix(packet[2] AND 'F0'x), -4)
    header.peace_cnt_gun2 = fix(packet[2] AND 'F'x)
ENDELSE 
header.staff_or_extrap = ishft(fix(packet[4] AND '80'x), -7)
header.m8sta = ishft((packet[4] AND '70'x), -4)
header.pacmo = packet[4] AND 'F'x
;The TM was messed up from May 30, 2001 to June 1, 2001.  The word
;containing the PM was wrong.  It should have been PM 5 for any WW
;data during that time
IF header.packet_time[0] GT 991180800L AND $
  header.packet_time[0] LT 991436400L THEN BEGIN
    IF header.science_mode EQ 5 THEN header.pacmo = 5
ENDIF
header.mem_address = long(packet[5]) * '10000'x + $
  long(packet[6]) * '100'x + $
  long(packet[7])
header.status = 1

IF header.sub_mode EQ 5 AND header.pacmo EQ 5 THEN BEGIN
  header.status = INVALID_EDI_DATA
ENDIF
;science mode 5 (WW) must use pacmo 1 or 5
IF header.science_mode EQ 5 AND $
  (header.pacmo NE 1 AND $
   header.pacmo NE 5) THEN BEGIN
  header.status = INVALID_EDI_DATA
ENDIF

;BM1 TM was corrupted during the following times:
;2001-06-07  02:47 - 04:11
;2001-06-13  11:10 - 13:10
;2001-06-17  00:07 - 03:16, 20:06 - 20:59
IF (header.packet_time[0] GE 991882020L AND $
    header.packet_time[0] LE 991887060L) OR $
  (header.packet_time[0] GE 992430600L AND $
   header.packet_time[0] LE 992437800L) OR $
  (header.packet_time[0] GE 992736420L AND $
   header.packet_time[0] LE 992747760L) OR $
  (header.packet_time[0] GE 992808360L AND $
   header.packet_time[0] LE 992811540L) THEN BEGIN
    header.status = INVALID_EDI_DATA
    IF verbose NE '' THEN BEGIN
        print, 'BM1 TM corrupted on June 7, 13, and 17 2001'
    ENDIF
ENDIF

return, header
END
