PRO dealias_clu_time_tag, header, time_tag1, time_tag2, btime, sc_id, status
;  Cluster II IDL Procedure
;
;  Abstract: dealias the time tag
;
;  created : Mark Chutter (based on a procedure by Kostantin Prokopui)
;  July 15, 1999
;
;  modified:
;  July 23, 1999 MWC I had the btime correction for EQS which
;                    is different for Cluster
;  Oct. 18, 1999 MWC I am not sure how it happened, but btime was
;                    indexed incorrectly in the line where delta is added
;  Mar. 15, 2000 MWC packet_time should be in atime format now
;                    (seconds and microseconds)
;  May   9, 2000 MWC changed -3008 to -3088
;  Aug. 28, 2000 MWC added check to see if difference in time tags is
;                    invalid; set btime[0] to INVALID_EDI_DATA and
;                    return
;  Sep. 26, 2000 MWC updated the ranges for negative deltas; don't
;                    pitch packets with bad deltas; just flag them
;  Oct. 20, 2000 MWC added status and do pitch packets with bad deltas
;  Nov.  2, 2000 MWC the adjustment to the btime is now exact (divide
;                    by 4096. rather than multiply by 244L)
;  Nov.  4, 2000 MWC added OOPS_TIME_TAG
;  Nov.  8, 2000 MWC if the packet time is between Nov. 4, 2000
;                    00:00:00 and Nov. 8 2000 then fix screwy time
;                    tags
;  Nov.  9, 2000 MWC also have to check staff_or_extrap in header;
;                    screwy time tags only in despin mode
;  Nov. 10, 2000 MWC updated cases according to e-mail from Hans
;  Nov. 13, 2000 MWC tried again to get Nov. 5/6 to work
;  Nov. 14, 2000 MWC should have used Nov. 3 as start of screwy time
;                    tags
;  Nov. 20, 2000 MWC NM1 PM0 is now different from WW modes
;  Nov. 27, 2000 MWC fixed staff or extrap error
;  Mar. 20, 2001 MWC was checking for btime[1] le 1, should have been
;                    lt 1
;  May   3, 2002 MWC added new code for Ambient GEOS mode
;  Jan.  5, 2004 MWC changed stop for negative btime to setting status
;                    to INVALID_EDI_DATA
;
;  Calling Interface:
;  header    EDI_HEADER (i) The EDI packet header
;  time_tag1 int (i) time tag at TMR
;  time_tag2 int (i) packet time tag
;  btime P_LONG * (i/o) BCI16 absolute time
;
;  Return Value:
;
;  Affected Variables:
;  btime is corrected with the dealiased time tag
;
;  Description:
;  dealias_time_tag is a translation from dealias_time_tag.for written by 
;  Hans Vaith dealias_clu_time_tag dealiases the packet time tag and then
;  sets the BCI16 absolute time for the packet.  This is not a user
;  level function.

COMMON pick, file_type, pick_lun

@pick_const
btime = lonarr(2)
delta = 0L
time_str = ''
status = 1
oops_stat = 0
oops = bytarr(55)

;This first section of code deals with screwy time tags between Nov. 3
;and Nov. 9, 2000.  I am sorry that it is here, and I don't promise it works
;properly, but then again, I would not put too much faith in the time
;tags for this period.
IF header.staff_or_extrap EQ 1 AND $
  header.packet_time[0] GT 973209600L AND $ ;'03-nov-2000 00:00:00'
  header.packet_time[0] LT 973728000L THEN BEGIN ;'09-nov-2000 00:00:00'
    kludge = 0
argh: kludge = kludge + 1
    delta = time_tag2 - time_tag1

    IF sc_id EQ 4 THEN BEGIN
        lower = -16
        IF header.sub_mode EQ 5 THEN BEGIN
            upper = 80
        ENDIF ELSE BEGIN
            IF header.pacmo EQ 1 THEN upper = 272 $
            ELSE upper = 528
        ENDELSE
        IF ((delta GE lower) AND (delta LE upper)) THEN $
          delta = delta $
        ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
          delta = delta + 2048 $
        ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
          delta = delta - 2048 $
        ELSE IF ((delta GE lower-63488) AND (delta LE upper-63488)) THEN $
          delta = delta + 63488 $
        ELSE IF ((delta GE lower-65536) AND (delta LE upper-65536)) THEN $
          delta = delta + 65536 $
        ELSE BEGIN
            oops_stat = 1
            on_ioerror, the_end
            point_lun, -1*pick_lun, oops_pos
            readu, pick_lun, oops
            point_lun, pick_lun, oops_pos
            oops_stat = 0
            time_tag1 = long(oops[23]) * '100'xL + long(oops[24])
        ENDELSE
    ENDIF ELSE IF sc_id EQ 3 THEN BEGIN
        upper = 16
        IF header.sub_mode EQ 5 THEN BEGIN
            lower = -64
        ENDIF ELSE BEGIN
            IF header.pacmo EQ 1 THEN lower = -256 $
            ELSE lower = -512
        ENDELSE
        IF ((delta GE lower) AND (delta LE upper)) THEN $
          delta = delta $
        ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
          delta = delta - 2048 $
        ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
          delta = delta + 2048 $
        ELSE IF ((delta GE lower+63488) AND (delta LE upper+63488)) THEN $
          delta = delta - 63488 $
        ELSE IF ((delta GE lower+65536) AND (delta LE upper+65536)) THEN $
          delta = delta - 65536 $
        ELSE BEGIN
            oops_stat = 1
            on_ioerror, the_end
            point_lun, -1*pick_lun, oops_pos
            readu, pick_lun, oops
            point_lun, pick_lun, oops_pos
            oops_stat = 0
            mem_dump = oops[15] AND '80'x
            science_mode = ishft((oops[16] AND 'F8'x), -3)

            IF mem_dump GT 0 THEN BEGIN

                btime[0] = INVALID_EDI_DATA
;                print, 'I am sometimes clever,'
;                print, 'but I cannot read the future this time.'
                status = DELTA_TIME_TAG_BIG
                return
            ENDIF ELSE time_tag1 = long(oops[23]) * '100'xL + long(oops[24])
        ENDELSE
    ENDIF
    the_end: IF oops_stat NE 0 AND kludge EQ 2 THEN BEGIN
        print, 'Timing in the last packet is likely to be useless'
        time_tag1 = time_tag2
    ENDIF

    IF kludge EQ 1 THEN GOTO, argh
    delta = time_tag2 - time_tag1
    GOTO, sploo;sorry for using a goto, the strange behavior in the time tags for these few days made me do it.
ENDIF

; first take the difference of the time tags
delta = time_tag2 - time_tag1

; de-alias the difference depending on EDI telemetry mode and packing mode
;  positive nominal delta (NMx/BM2 pacmo2 or BM1 pacmo0)
IF (((header.sub_mode NE 5) AND (header.pacmo EQ 2)) OR $
    ((header.sub_mode EQ 5) AND (header.pacmo EQ 0))) THEN BEGIN

    IF ((delta GE      1) AND (delta LE     80)) THEN delta = delta $
    ELSE IF ((delta GE  -2047) AND (delta LE  -1968)) THEN $
      delta = delta+2048 $
    ELSE IF ((delta GE   2049) AND (delta LE   2128)) THEN $
      delta = delta-2048 $
    ELSE IF ((delta GE -63487) AND (delta LE -63408)) THEN $
      delta = delta+63488 $
    ELSE IF ((delta GE -65535) AND (delta LE -65456)) THEN $
      delta = delta+65536 $
    ELSE BEGIN
        btime[0] = INVALID_EDI_DATA
        print, 'delta in time tags not valid!'
        status = DELTA_TIME_TAG_BIG
        return
    ENDELSE
  
ENDIF

; negative nominal delta (NM1 PM0)
IF header.sub_mode NE 5 AND header.pacmo EQ 0 THEN BEGIN
    IF ((delta GE  1008) AND (delta LE  2047)) THEN delta = delta-2048
    IF ((delta GE -3008) AND (delta LE -2049)) THEN delta = delta+2048
    IF ((delta GE 62448) AND (delta LE 63487)) THEN delta = delta-63488
    IF ((delta GE 64496) AND (delta LE 65535)) THEN delta = delta-65536  
ENDIF
; negative nominal delta (NMx/BM2 pacmo1/pacmo5 or BM1 pacmo1)
; or NM1 pacmo5
IF (((header.sub_mode NE 5) AND (header.pacmo NE 2)) OR $
    ((header.sub_mode EQ 5) AND (header.pacmo EQ 1))) THEN BEGIN

    IF header.packet_time[0] LT 973209600L THEN BEGIN ;'03-nov-2000 00:00:00'
        upper = 16
        IF header.sub_mode EQ 5 THEN BEGIN
            lower = -64
        ENDIF ELSE BEGIN
            IF header.pacmo EQ 1 THEN lower = -256 $
            ELSE lower = -512
        ENDELSE
        IF ((delta GE lower) AND (delta LE upper)) THEN $
          delta = delta $
        ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
          delta = delta - 2048 $
        ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
          delta = delta + 2048 $
        ELSE IF ((delta GE lower+63488) AND (delta LE upper+63488)) THEN $
          delta = delta - 63488 $
        ELSE IF ((delta GE lower+65536) AND (delta LE upper+65536)) THEN $
          delta = delta - 65536 $
        ELSE BEGIN
            status = DELTA_TIME_TAG_BIG
            pick_cvt_sec_vax, header.packet_time, time_str
            print, 'delta in time tags not valid at ', time_str
            print, 'time tag at TMR: ', time_tag1, $
              ' data time tag: ', time_tag2
            return
        ENDELSE
    ENDIF
    IF header.packet_time[0] GE 973209600L THEN BEGIN ;'03-nov-2000 00:00:00'
        IF header.science_mode EQ 5 THEN BEGIN
            lower = -16
            IF header.sub_mode EQ 5 THEN BEGIN
                upper = 80
            ENDIF ELSE BEGIN
                IF header.pacmo EQ 1 THEN upper = 272 $
                ELSE upper = 528
            ENDELSE
        ENDIF ELSE BEGIN
            IF header.sub_mode EQ 5 THEN BEGIN
                lower = -8
                upper = 40
            ENDIF ELSE BEGIN
                lower = -264
                upper = 8
            ENDELSE
        ENDELSE
        IF ((delta GE lower) AND (delta LE upper)) THEN $
          delta = delta $
        ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
          delta = delta + 2048 $
        ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
          delta = delta - 2048 $
        ELSE IF ((delta GE lower-63488) AND (delta LE upper-63488)) THEN $
          delta = delta + 63488 $
        ELSE IF ((delta GE lower-65536) AND (delta LE upper-65536)) THEN $
          delta = delta + 65536 $
        ELSE BEGIN
            status = DELTA_TIME_TAG_BIG
            pick_cvt_sec_vax, header.packet_time, time_str
            print, 'delta in time tags not valid at ', time_str
            print, 'time tag at TMR: ', time_tag1, $
              ' data time tag: ', time_tag2
            print, 'delta: ', delta
            return
        ENDELSE
    ENDIF
  
ENDIF

sploo:
; For the calculation of the BCI16 absolute times (ms of day) we need
; to extract from the packet-time the CTIME in seconds since 1970 and 
; us per second. The length of one TMR must be subtracted from this 
; (5.152221 sec) because all SC packets have been deducted in the 
; prevous TMR.

TMR_length = [5L, 152221L]
btime = sub_ctime(header.packet_time, TMR_length)
btime = add_ctime(btime, $
                  [0L, LONG(1000000. * delta / 4096.)])
btime = add_ctime(btime, $
                  [LONG(delta / 4096.), 0L])

;btime[0] = btime[0] + LONG(delta / 4096.)
;btime[1] = btime[1] + LONG(1000000. * delta / 4096.) ;244L * LONG(delta) 

IF btime[1] LT 0L THEN BEGIN
    print, 'Negative btime'
    status = INVALID_EDI_DATA
ENDIF
; check for overflow and underflow in the microsecond portion
;IF (btime[1] GE 1000000L) THEN BEGIN
;    btime[1] = btime[1] - 1000000L
;    btime[0] = btime[0] + 1L
;ENDIF

;IF (btime[1] LT 0L) THEN BEGIN
;    btime[1] = btime[1] + 1000000L
;    btime[0] = btime[0] - 1L
;ENDIF
;print, btime
;print, sub_ctime(header.packet_time, TMR_length)
;print, bstime, delta*244L

return
END
